/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.downsampling;

import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class PassThroughDownsampler
extends ReadsDownsampler {
    private LinkedList<GATKRead> selectedReads;

    public PassThroughDownsampler() {
        this.clearItems();
    }

    @Override
    public void submit(GATKRead newRead) {
        Utils.nonNull(newRead, "newRead");
        this.selectedReads.add(newRead);
    }

    @Override
    public boolean hasFinalizedItems() {
        return !this.selectedReads.isEmpty();
    }

    @Override
    public List<GATKRead> consumeFinalizedItems() {
        LinkedList<GATKRead> downsampledItems = this.selectedReads;
        this.clearItems();
        return downsampledItems;
    }

    @Override
    public boolean hasPendingItems() {
        return false;
    }

    @Override
    public GATKRead peekFinalized() {
        return this.selectedReads.isEmpty() ? null : this.selectedReads.getFirst();
    }

    @Override
    public GATKRead peekPending() {
        return null;
    }

    @Override
    public int size() {
        return this.selectedReads.size();
    }

    @Override
    public void signalEndOfInput() {
    }

    @Override
    public void clearItems() {
        this.selectedReads = new LinkedList();
    }

    @Override
    public boolean requiresCoordinateSortOrder() {
        return false;
    }

    @Override
    public void signalNoMoreReadsBefore(GATKRead read) {
        Utils.nonNull(read);
    }
}

