/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.downsampling;

import htsjdk.samtools.SAMFileHeader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.hellbender.utils.downsampling.ReservoirDownsampler;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadCoordinateComparator;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public final class PositionalDownsampler
extends ReadsDownsampler {
    private final ReservoirDownsampler reservoir;
    private final SAMFileHeader header;
    private GATKRead previousRead;
    private List<GATKRead> finalizedReads;

    public PositionalDownsampler(int targetCoverage, SAMFileHeader header) {
        Utils.validateArg(targetCoverage > 0, "targetCoverage must be > 0");
        Utils.nonNull(header);
        this.reservoir = new ReservoirDownsampler(targetCoverage);
        this.finalizedReads = new ArrayList<GATKRead>();
        this.header = header;
        this.clearItems();
        this.resetStats();
    }

    @Override
    public void submit(GATKRead newRead) {
        Utils.nonNull(newRead, "newRead");
        this.handlePositionalChange(newRead);
        if (ReadUtils.readHasNoAssignedPosition(newRead)) {
            this.finalizedReads.add(newRead);
        } else {
            int reservoirPreviouslyDiscardedItems = this.reservoir.getNumberOfDiscardedItems();
            this.reservoir.submit(newRead);
            this.incrementNumberOfDiscardedItems(this.reservoir.getNumberOfDiscardedItems() - reservoirPreviouslyDiscardedItems);
        }
        this.previousRead = newRead;
    }

    private void handlePositionalChange(GATKRead newRead) {
        if (this.previousRead != null) {
            int cmpDiff = ReadCoordinateComparator.compareCoordinates(this.previousRead, newRead, this.header);
            if (cmpDiff == 1) {
                throw new IllegalStateException(String.format("Reads must be coordinate sorted (earlier %s later %s)", this.previousRead, newRead));
            }
            if (cmpDiff != 0) {
                this.finalizeReservoir(true);
            }
        }
    }

    private void finalizeReservoir(boolean expectFinalizedItems) {
        this.reservoir.signalEndOfInput();
        if (expectFinalizedItems && !this.reservoir.hasFinalizedItems()) {
            throw new GATKException.ShouldNeverReachHereException("Expected downsampled items to be present when none are");
        }
        this.finalizedReads.addAll(this.reservoir.consumeFinalizedItems());
        this.reservoir.resetStats();
        this.previousRead = null;
    }

    @Override
    public boolean hasFinalizedItems() {
        return !this.finalizedReads.isEmpty();
    }

    @Override
    public List<GATKRead> consumeFinalizedItems() {
        List<GATKRead> toReturn = this.finalizedReads;
        this.finalizedReads = new ArrayList<GATKRead>();
        return toReturn;
    }

    @Override
    public boolean hasPendingItems() {
        return this.reservoir.hasFinalizedItems() || this.reservoir.hasPendingItems();
    }

    @Override
    public GATKRead peekFinalized() {
        return this.finalizedReads.isEmpty() ? null : this.finalizedReads.get(0);
    }

    @Override
    public GATKRead peekPending() {
        return Optional.ofNullable(this.reservoir.peekFinalized()).orElse(this.reservoir.peekPending());
    }

    @Override
    public int size() {
        return this.finalizedReads.size() + this.reservoir.size();
    }

    @Override
    public void signalEndOfInput() {
        this.finalizeReservoir(false);
    }

    @Override
    public void clearItems() {
        this.reservoir.clearItems();
        this.reservoir.resetStats();
        this.finalizedReads.clear();
        this.previousRead = null;
    }

    @Override
    public boolean requiresCoordinateSortOrder() {
        return true;
    }

    @Override
    public void signalNoMoreReadsBefore(GATKRead read) {
        Utils.nonNull(read, "Positional downsampler requires non-null reads");
        this.handlePositionalChange(read);
    }
}

