/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.downsampling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.ReadsDownsampler;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class ReservoirDownsampler
extends ReadsDownsampler {
    private final int targetSampleSize;
    private final boolean expectFewOverflows;
    private List<GATKRead> reservoir;
    private boolean isLinkedList;
    private int totalReadsSeen;
    private boolean endOfInputStream;

    public ReservoirDownsampler(int targetSampleSize, boolean expectFewOverflows) {
        if (targetSampleSize <= 0) {
            throw new IllegalArgumentException("Cannot do reservoir downsampling with a sample size <= 0");
        }
        this.targetSampleSize = targetSampleSize;
        this.expectFewOverflows = expectFewOverflows;
        this.clearItems();
        this.resetStats();
    }

    public ReservoirDownsampler(int targetSampleSize) {
        this(targetSampleSize, false);
    }

    @Override
    public void submit(GATKRead newRead) {
        Utils.nonNull(newRead, "newRead");
        Utils.validate(!this.endOfInputStream, "attempt to submit read after end of input stream has been signaled");
        ++this.totalReadsSeen;
        if (this.totalReadsSeen <= this.targetSampleSize) {
            this.reservoir.add(newRead);
        } else {
            int randomSlot;
            if (this.isLinkedList) {
                this.reservoir = new ArrayList<GATKRead>(this.reservoir);
                this.isLinkedList = false;
            }
            if ((randomSlot = Utils.getRandomGenerator().nextInt(this.totalReadsSeen)) < this.targetSampleSize) {
                this.reservoir.set(randomSlot, newRead);
            }
            this.incrementNumberOfDiscardedItems(1);
        }
    }

    @Override
    public boolean hasFinalizedItems() {
        return this.endOfInputStream && !this.reservoir.isEmpty();
    }

    @Override
    public List<GATKRead> consumeFinalizedItems() {
        if (this.hasFinalizedItems()) {
            List<GATKRead> downsampledItems = this.reservoir;
            this.clearItems();
            return downsampledItems;
        }
        if (!this.endOfInputStream) {
            return Collections.emptyList();
        }
        this.clearItems();
        return Collections.emptyList();
    }

    @Override
    public boolean hasPendingItems() {
        return !this.endOfInputStream && !this.reservoir.isEmpty();
    }

    @Override
    public GATKRead peekFinalized() {
        return this.hasFinalizedItems() ? this.reservoir.get(0) : null;
    }

    @Override
    public GATKRead peekPending() {
        return this.hasPendingItems() ? this.reservoir.get(0) : null;
    }

    @Override
    public int size() {
        return this.reservoir.size();
    }

    @Override
    public void signalEndOfInput() {
        this.endOfInputStream = true;
    }

    @Override
    public void clearItems() {
        this.reservoir = this.expectFewOverflows ? new LinkedList() : new ArrayList(this.targetSampleSize);
        this.isLinkedList = this.expectFewOverflows;
        this.totalReadsSeen = 0;
        this.endOfInputStream = false;
    }

    @Override
    public boolean requiresCoordinateSortOrder() {
        return false;
    }

    @Override
    public void signalNoMoreReadsBefore(GATKRead read) {
        Utils.nonNull(read);
    }
}

