/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.dragstr;

import it.unimi.dsi.fastutil.doubles.AbstractDoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;

public final class DoubleSequence {
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?");
    private final String input;
    private final String description;
    private final DoubleList values;
    public static final Pattern STEP_DECRIPTION_PATTERN = Pattern.compile(String.format("^(%s):(%s):(%s)$", DOUBLE_PATTERN, DOUBLE_PATTERN, DOUBLE_PATTERN));

    public DoubleSequence(String descriptor) {
        double[] valueArray;
        Utils.nonNull(descriptor);
        Matcher matcher = STEP_DECRIPTION_PATTERN.matcher(descriptor);
        if (!matcher.matches()) {
            throw new CommandLineException.BadArgumentValue("invalid double sequence specificatior: " + descriptor);
        }
        double start = this.parseDouble(matcher.group(1), "start");
        double step = this.parseDouble(matcher.group(2), "step");
        double limit = this.parseDouble(matcher.group(3), "limit");
        try {
            valueArray = MathUtils.doubles(start, limit, step);
        }
        catch (RuntimeException ex) {
            throw new UserException.BadInput(ex.getMessage() + " (" + descriptor + ")");
        }
        this.values = new AbstractDoubleList(){

            public int size() {
                return valueArray.length;
            }

            public double getDouble(int index) {
                return valueArray[index];
            }

            public double[] toDoubleArray() {
                return (double[])valueArray.clone();
            }
        };
        this.description = String.format("starting at %s to %s in increments/decrements of %s", matcher.group(1), matcher.group(3), matcher.group(2));
        this.input = descriptor;
    }

    private double parseDouble(String str, String role) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException ex) {
            throw new UserException.BadInput(role + " is not a double formatted string: " + str, ex);
        }
    }

    public double get(int index) {
        Utils.validIndex(index, this.values.size());
        return (Double)this.values.get(index);
    }

    public long size() {
        return this.values.size();
    }

    public String toString() {
        return this.input;
    }

    public double min() {
        int size = this.values.size();
        if (size > 2) {
            return Math.min((Double)this.values.get(0), (Double)this.values.get(size - 1));
        }
        return this.values.isEmpty() ? Double.NaN : (Double)this.values.get(0);
    }

    public double max() {
        int size = this.values.size();
        if (size > 2) {
            return Math.max((Double)this.values.get(0), (Double)this.values.get(size - 1));
        }
        return this.values.isEmpty() ? Double.NaN : (Double)this.values.get(0);
    }

    public double step() {
        return this.values.size() < 2 ? Double.NaN : this.values.getDouble(1) - this.values.getDouble(0);
    }

    public double[] toDoubleArray() {
        return this.values.toDoubleArray();
    }

    public String getDescription() {
        return this.description;
    }
}

