/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.dragstr;

import java.util.stream.IntStream;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public final class DragstrParams {
    private static final String NON_PERSISTENT_NAME = "<non-persistent>";
    private static final String DEFAULT_NAME = "<default>";
    private String name;
    private static final double[][] DEFAULT_GOP = new double[][]{{45.0, 45.0, 45.0, 45.0, 45.0, 45.0, 40.5, 33.5, 28.0, 24.0, 21.75, 21.75, 21.75, 21.75, 21.75, 21.75, 21.75, 21.75, 21.75, 21.75}, {39.5, 39.5, 39.5, 39.5, 36.0, 30.0, 27.25, 25.0, 24.25, 24.75, 26.25, 26.25, 26.25, 26.25, 26.25, 26.25, 26.25, 26.25, 26.25, 26.75}, {38.5, 41.0, 41.0, 41.0, 41.0, 37.5, 35.25, 34.75, 34.75, 33.25, 33.25, 33.25, 32.5, 30.75, 28.5, 29.0, 29.0, 29.0, 29.0, 29.0}, {37.5, 39.0, 39.0, 37.75, 34.0, 34.0, 30.25, 30.25, 30.25, 30.25, 30.25, 30.25, 30.25, 30.25, 30.25, 31.75, 31.75, 31.75, 31.75, 31.75}, {37.0, 40.0, 40.0, 40.0, 36.0, 35.0, 24.5, 24.5, 24.5, 24.5, 22.5, 22.5, 22.5, 23.5, 23.5, 23.5, 23.5, 23.5, 23.5, 23.5}, {36.25, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0, 40.0}, {36.0, 40.5, 40.5, 40.5, 20.75, 20.75, 20.75, 20.75, 20.75, 20.75, 20.75, 20.75, 20.75, 20.75, 20.75, 20.75, 20.75, 20.75, 20.75, 20.75}, {36.25, 39.75, 32.75, 32.75, 32.75, 32.75, 32.75, 32.75, 32.75, 32.75, 32.75, 32.75, 32.75, 32.75, 32.75, 32.75, 32.75, 32.75, 32.75, 32.75}};
    private static final double[][] DEFAULT_API = new double[][]{{39.0, 39.0, 37.0, 35.0, 32.0, 26.0, 20.0, 16.0, 12.0, 10.0, 8.0, 7.0, 7.0, 6.0, 6.0, 5.0, 5.0, 4.0, 4.0, 4.0}, {30.0, 30.0, 29.0, 22.0, 17.0, 14.0, 11.0, 8.0, 6.0, 5.0, 4.0, 4.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 2.0, 2.0}, {27.0, 27.0, 25.0, 18.0, 14.0, 12.0, 9.0, 7.0, 5.0, 4.0, 3.0, 3.0, 3.0, 3.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0}, {27.0, 27.0, 18.0, 9.0, 9.0, 9.0, 9.0, 3.0, 3.0, 3.0, 3.0, 3.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0}, {29.0, 29.0, 18.0, 8.0, 8.0, 8.0, 4.0, 3.0, 3.0, 3.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0}, {25.0, 25.0, 10.0, 10.0, 10.0, 4.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0}, {21.0, 21.0, 11.0, 11.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0, 5.0}, {18.0, 18.0, 10.0, 6.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0, 4.0}};
    private static final double[][] DEFAULT_GCP = (double[][])IntStream.rangeClosed(1, 8).mapToDouble(period -> (double)Math.round(1000.0 / (double)period) / 100.0).mapToObj(value -> MathUtils.doubles(20, value)).toArray(x$0 -> new double[x$0][]);
    public static final DragstrParams DEFAULT = new DragstrParams(8, 20, DEFAULT_GOP, DEFAULT_GCP, DEFAULT_API, "<default>");
    private final int maxPeriod;
    private final int maxRepeats;
    private final double[][] gop;
    private final double[][] gcp;
    private final double[][] api;

    public static DragstrParams of(int maxPeriod, int maxRepeats, double[][] gop, double[][] gcp, double[][] api) {
        return DragstrParams.of(maxPeriod, maxRepeats, gop, gcp, api, NON_PERSISTENT_NAME);
    }

    public static DragstrParams of(int maxPeriod, int maxRepeats, double[][] gop, double[][] gcp, double[][] api, String name) {
        ParamUtils.isPositive(maxPeriod, "max period must be a positive");
        ParamUtils.isPositive(maxRepeats, "max repeats must be a positive");
        Utils.nonNull(gop, "gop cannot be null");
        Utils.nonNull(gcp, "gcp cannot be null");
        Utils.nonNull(api, "api cannot be null");
        Utils.validate(gop.length == maxPeriod, "input gop length must match maxPeriod");
        Utils.validate(gcp.length == maxPeriod, "input gcp length must match maxPeriod");
        Utils.validate(api.length == maxPeriod, "input api length must match maxPeriod");
        for (int i = 0; i < maxPeriod; ++i) {
            double[] gopRow = gop[i];
            double[] gcpRow = gcp[i];
            double[] apiRow = api[i];
            for (int j = 0; j < maxRepeats; ++j) {
                Utils.validate(gopRow[j] >= 0.0 && Double.isFinite(gopRow[j]), "bad gop value: " + gopRow[j]);
                Utils.validate(gcpRow[j] >= 0.0 && Double.isFinite(gcpRow[j]), "bad gcp value: " + gcpRow[j]);
                Utils.validate(apiRow[j] >= 0.0 && Double.isFinite(apiRow[j]), "bad api value: " + apiRow[j]);
            }
        }
        DragstrParams.checkMatricesAreValid(maxPeriod, maxRepeats, gop, gcp, api);
        return new DragstrParams(maxPeriod, maxRepeats, (double[][])gop.clone(), (double[][])gcp.clone(), (double[][])api.clone(), name);
    }

    private DragstrParams(int maxPeriod, int maxRepeats, double[][] gop, double[][] gcp, double[][] api, String name) {
        this.maxPeriod = maxPeriod;
        this.maxRepeats = maxRepeats;
        this.gop = gop;
        this.gcp = gcp;
        this.api = api;
        this.name = name;
    }

    private static void checkMatricesAreValid(int maxPeriod, int maxRepeats, double[][] gopMatrix, double[][] gcpMatrix, double[][] apiMatrix) {
        DragstrParams.checkMatrixIsValid(maxPeriod, maxRepeats, gopMatrix, "GOP");
        DragstrParams.checkMatrixIsValid(maxPeriod, maxRepeats, gcpMatrix, "GCP");
        DragstrParams.checkMatrixIsValid(maxPeriod, maxRepeats, apiMatrix, "API");
    }

    private static void checkMatrixIsValid(int maxPeriod, int maxRepeatLength, double[][] matrix, String name) {
        Utils.nonNull(matrix, "the " + name + " matrix provided cannot be null");
        if (matrix.length != maxPeriod) {
            throw new UserException.BadInput("the " + name + " matrix provided has the wrong number of rows");
        }
        for (double[] row : matrix) {
            Utils.nonNull(row, "the " + name + " matrix contains null rows");
            if (row.length == maxRepeatLength) continue;
            throw new UserException.BadInput("the " + name + " matrix contains rows with length that does not match the max repeat length");
        }
    }

    private double lookup(double[][] matrix, int period, int repeats) {
        ParamUtils.isPositive(period, "period");
        ParamUtils.isPositive(repeats, "repeat length in units");
        int periodIndex = period < this.maxPeriod ? period - 1 : this.maxPeriod - 1;
        int repeatIndex = repeats < this.maxRepeats ? repeats - 1 : this.maxRepeats - 1;
        return matrix[periodIndex][repeatIndex];
    }

    public double gop(int period, int repeats) {
        return this.lookup(this.gop, period, repeats);
    }

    public double gcp(int period, int repeats) {
        return this.lookup(this.gcp, period, repeats);
    }

    public double api(int period, int repeats) {
        return this.lookup(this.api, period, repeats);
    }

    public int maximumPeriod() {
        return this.maxPeriod;
    }

    public int maximumRepeats() {
        return this.maxRepeats;
    }

    public int maximumLengthInBasePairs() {
        return this.maxPeriod * this.maxRepeats;
    }

    public String toString() {
        return this.name;
    }

    void setName(String name) {
        this.name = Utils.nonNull(name);
    }
}

