/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.dragstr;

import org.apache.commons.lang.math.IntRange;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.dragstr.DoubleSequence;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParams;

public final class DragstrParamsBuilder {
    private final int maxPeriod;
    private final int maxRepeats;
    public final double[][] gp;
    public final double[][] gcp;
    public final double[][] api;

    public DragstrParamsBuilder(int maxPeriod, int maxRepeats) {
        this.maxPeriod = maxPeriod;
        this.maxRepeats = maxRepeats;
        this.gp = new double[maxPeriod][maxRepeats];
        this.gcp = new double[maxPeriod][maxRepeats];
        this.api = new double[maxPeriod][maxRepeats];
    }

    public void set(int period, IntRange repeatRange, double gp, double gcp, double api) {
        for (int i = repeatRange.getMinimumInteger(); i <= repeatRange.getMaximumInteger(); ++i) {
            this.set(period, i, gp, gcp, api);
        }
    }

    public void set(int period, int repeats, double gp, double gcp, double api) {
        int p = period - 1;
        int r = repeats - 1;
        Utils.validIndex(p, this.maxPeriod);
        Utils.validIndex(r, this.maxRepeats);
        this.gp[p][r] = gp;
        this.gcp[p][r] = gcp;
        this.api[p][r] = api;
    }

    public DragstrParams make(DoubleSequence gopValues) {
        return this.make(gopValues.min(), gopValues.max(), gopValues.step());
    }

    public DragstrParams make(double minGop, double maxGop, double stepwise) {
        double[][] gop = new double[this.gp.length][this.gp[0].length];
        for (int i = 0; i < gop.length; ++i) {
            for (int j = 0; j < gop[i].length; ++j) {
                gop[i][j] = Math.max(minGop, this.gopCalculation(this.gp[i][j], this.gcp[i][j], i + 1, 0.0, maxGop, stepwise));
            }
        }
        return DragstrParams.of(this.maxPeriod, this.maxRepeats, gop, this.gcp, this.api);
    }

    private double gopCalculation(double gp, double gcp, int period, double minGop, double maxGop, double stepwise) {
        double gpProb = Math.pow(10.0, -0.1 * gp);
        double bestGop = minGop;
        double c = Math.pow(10.0, -0.1 * gcp);
        double bestCost = Double.POSITIVE_INFINITY;
        double gop = minGop;
        while (maxGop - gop > -0.001) {
            double prNoGap;
            double g = Math.pow(10.0, -0.1 * gop);
            double prGap = g * Math.pow(c, period - 1) * (1.0 - c);
            double cost = Math.abs(prGap / (prNoGap = Math.pow(1.0 - 2.0 * g, period + 1)) - gpProb);
            if (cost < bestCost) {
                bestGop = gop;
                bestCost = cost;
            }
            gop += stepwise;
        }
        return bestGop;
    }

    public double gp(int period, int repeatLength) {
        return this.gp[period - 1][repeatLength - 1];
    }

    public double api(int period, int repeatLength) {
        return this.api[period - 1][repeatLength - 1];
    }
}

