/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.dragstr;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.hellbender.utils.Utils;

public final class DragstrReferenceAnalyzer {
    private final int start;
    private final int end;
    private final byte[] bases;
    private final int[] period;
    private final int[] forwardRepeats;

    private DragstrReferenceAnalyzer(byte[] bases, int start, int end, int[] period, int[] repeats) {
        this.start = start;
        this.end = end;
        this.bases = bases;
        this.period = period;
        this.forwardRepeats = repeats;
    }

    public int repeatLength(int position) {
        int result = this.lookup(position, this.forwardRepeats);
        int period = this.period[position - this.start];
        int j = position + period;
        int k = period;
        for (int i = position - 1; i >= 0 && this.bases[i] == this.bases[--j]; --i) {
            if (--k != 0) continue;
            k = period;
            ++result;
        }
        return result;
    }

    public byte[] repeatUnit(int position) {
        int length = this.lookup(position, this.period);
        return Arrays.copyOfRange(this.bases, position, position + length);
    }

    public String repeatUnitAsString(int position) {
        return new String(this.repeatUnit(position));
    }

    public int period(int position) {
        return this.lookup(position, this.period);
    }

    private int lookup(int position, int[] array) {
        int offset = position - this.start;
        if (offset >= 0 && position <= this.end) {
            return array[offset];
        }
        throw new IllegalArgumentException("postion " + position + " is outside bounds");
    }

    public static DragstrReferenceAnalyzer of(byte[] bases, int start, int end, int maxPeriod) {
        Utils.nonNull(bases, "the input bases cannot be null");
        if (end < start || start < 0 || end > bases.length) {
            throw new IndexOutOfBoundsException("bad indexes " + start + " " + end + " " + bases.length);
        }
        if (start >= end) {
            return new DragstrReferenceAnalyzer(bases, start, end, ArrayUtils.EMPTY_INT_ARRAY, ArrayUtils.EMPTY_INT_ARRAY);
        }
        int[] repeats = DragstrReferenceAnalyzer.processPeriodOne(bases, start, end);
        int[] periods = new int[end - start];
        Arrays.fill(periods, 1);
        for (int period = 2; period <= maxPeriod && bases.length >= period << 1; ++period) {
            int rightMargin;
            int position;
            int rightMostStart = position = rightMargin - period;
            int remainingToMatchUnit = period;
            int carryBack = 1;
            for (rightMargin = Math.min(end + period, bases.length) - 1; rightMargin < bases.length && bases[position++] == bases[rightMargin]; ++rightMargin) {
                if (--remainingToMatchUnit != 0) continue;
                ++carryBack;
                remainingToMatchUnit = period;
            }
            int resultArrayOffset = rightMostStart - start;
            if (resultArrayOffset >= 0 && carryBack > repeats[resultArrayOffset]) {
                repeats[resultArrayOffset] = carryBack;
                periods[resultArrayOffset] = period;
            }
            boolean inTragetRange = false;
            position = rightMostStart - 1;
            int positionPlusPeriod = position + period;
            resultArrayOffset = position - start;
            while (position >= start) {
                if (bases[position] == bases[positionPlusPeriod]) {
                    if (--remainingToMatchUnit == 0) {
                        ++carryBack;
                        remainingToMatchUnit = period;
                    }
                    if ((inTragetRange |= position < end) && carryBack > repeats[resultArrayOffset]) {
                        repeats[resultArrayOffset] = carryBack;
                        periods[resultArrayOffset] = period;
                    }
                } else {
                    carryBack = 1;
                    remainingToMatchUnit = period;
                }
                --position;
                --positionPlusPeriod;
                --resultArrayOffset;
            }
        }
        return new DragstrReferenceAnalyzer(bases, start, end, periods, repeats);
    }

    private static int[] processPeriodOne(byte[] bases, int start, int end) {
        int rightMargin;
        int[] repeats = new int[end - start];
        byte last = bases[end - 1];
        for (rightMargin = end; rightMargin < bases.length && bases[rightMargin] == last; ++rightMargin) {
        }
        int carryBack = rightMargin - end;
        int position = end - 1;
        int offset = position - start;
        while (position >= start) {
            byte next = bases[position];
            repeats[offset] = next == last ? ++carryBack : (carryBack = 1);
            last = next;
            --position;
            --offset;
        }
        return repeats;
    }
}

