/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.dragstr;

import com.google.common.io.Files;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceDictionaryCodec;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.Lazy;
import htsjdk.samtools.util.LineReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.NullWriter;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.dragstr.DragstrLocus;
import org.broadinstitute.hellbender.tools.dragstr.DragstrLocusUtils;
import org.broadinstitute.hellbender.tools.dragstr.STRDecimationTable;
import org.broadinstitute.hellbender.utils.BinaryTableReader;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.ZipUtils;

public final class STRTableFile
implements AutoCloseable {
    public static final String SITES_FILE_NAME = "sites.bin";
    public static final String SITES_INDEX_FILE_NAME = "sites.idx";
    public static final String SITES_TEXT_FILE_NAME = "sites.txt";
    public static final String SUMMARY_FILE_NAME = "summary.txt";
    public static final String REF_DICTIONARY_FILE_NAME = "reference.dict";
    public static final String DECIMATION_TABLE_FILE_NAME = "decimation.txt";
    private final File dir;
    private boolean closed;
    private SAMSequenceDictionary dictionary;
    private Lazy<DragstrLocusUtils.BinaryTableIndex> lociIndex;
    private static final String[] ESSENTIAL_FILES = new String[]{"sites.bin", "sites.idx", "reference.dict", "decimation.txt"};

    private STRTableFile(File dir) {
        this.dir = dir;
        String source = new File(dir, REF_DICTIONARY_FILE_NAME).toString();
        try (BufferedLineReader lineReader = new BufferedLineReader((InputStream)new FileInputStream(source));){
            this.dictionary = new SAMSequenceDictionaryCodec((Writer)new NullWriter()).decode((LineReader)lineReader, source);
        }
        catch (FileNotFoundException e) {
            throw new GATKException("cannot read dictionary for str-table-file in " + dir);
        }
        this.lociIndex = new Lazy(() -> DragstrLocusUtils.BinaryTableIndex.load(new File(this.dir, SITES_INDEX_FILE_NAME).toString()));
    }

    public BinaryTableReader<DragstrLocus> locusReader(SimpleInterval interval) {
        this.checkIsNotClose();
        try {
            return DragstrLocusUtils.binaryReader(new File(this.dir, SITES_FILE_NAME).toString(), (DragstrLocusUtils.BinaryTableIndex)this.lociIndex.get(), this.dictionary.getSequenceIndex(interval.getContig()), interval.getStart(), interval.getEnd());
        }
        catch (IOException ex) {
            throw new GATKException("problems accessing to " + interval + " in str-table-file " + this.dir);
        }
    }

    public BinaryTableReader<DragstrLocus> locusReader() {
        this.checkIsNotClose();
        try {
            return DragstrLocusUtils.binaryReader(new File(this.dir, SITES_FILE_NAME));
        }
        catch (IOException ex) {
            throw new GATKException("problems accessing to in str-table-file " + this.dir);
        }
    }

    public static STRTableFile open(GATKPath path) {
        File dir = Files.createTempDir();
        try {
            ZipUtils.unzip(path, dir, ESSENTIAL_FILES);
        }
        catch (Exception ex) {
            throw new GATKException("issues loading str-table-file at " + path, ex);
        }
        for (String essentialFileName : ESSENTIAL_FILES) {
            if (new File(dir, essentialFileName).exists()) continue;
            throw new GATKException("missing files in the str-table zip: e.g. " + essentialFileName);
        }
        return new STRTableFile(dir);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                FileUtils.deleteDirectory((File)this.dir);
            }
            catch (IOException e) {
                throw new GATKException("issues closing the str-table-file at " + this.dir, e);
            }
        }
    }

    private void checkIsNotClose() {
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
    }

    public STRDecimationTable decimationTable() {
        this.checkIsNotClose();
        return new STRDecimationTable(new File(this.dir, DECIMATION_TABLE_FILE_NAME).toString());
    }

    public SAMSequenceDictionary dictionary() {
        this.checkIsNotClose();
        return this.dictionary;
    }
}

