/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.fragments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class FragmentCollection<T> {
    private final Collection<T> singletons;
    private final Collection<Pair<T, T>> overlappingPairs;

    private FragmentCollection(Collection<T> singletons, Collection<Pair<T, T>> overlappingPairs) {
        this.singletons = singletons == null ? Collections.emptyList() : singletons;
        this.overlappingPairs = overlappingPairs == null ? Collections.emptyList() : overlappingPairs;
    }

    public Collection<T> getSingletonReads() {
        return Collections.unmodifiableCollection(this.singletons);
    }

    public Collection<Pair<T, T>> getOverlappingPairs() {
        return Collections.unmodifiableCollection(this.overlappingPairs);
    }

    private static <T> FragmentCollection<T> create(Iterable<T> readContainingObjects, int nElements, Function<T, GATKRead> getter) {
        Collection singletons = null;
        ArrayList<ImmutablePair> overlapping = null;
        LinkedHashMap<String, T> nameMap = null;
        int lastStart = -1;
        for (T p : readContainingObjects) {
            Object pe1;
            GATKRead read = getter.apply(p);
            if (read.getStart() < lastStart) {
                throw new IllegalArgumentException(String.format("FragmentUtils.create assumes that the incoming objects are ordered by SAMRecord alignment start, but saw a read %s with alignment start %d before the previous start %d", read.getName(), read.getStart(), lastStart));
            }
            lastStart = read.getStart();
            if (!read.isPaired() || read.mateIsUnmapped() || read.getMateStart() == 0 || read.getMateStart() > read.getEnd()) {
                if (singletons == null) {
                    singletons = new ArrayList(nElements);
                }
                singletons.add(p);
                continue;
            }
            String readName = read.getName();
            Object v0 = pe1 = nameMap == null ? null : nameMap.get(readName);
            if (pe1 != null) {
                if (overlapping == null) {
                    overlapping = new ArrayList<ImmutablePair>();
                }
                overlapping.add(ImmutablePair.of(pe1, p));
                nameMap.remove(readName);
                continue;
            }
            if (nameMap == null) {
                nameMap = new LinkedHashMap<String, T>(nElements);
            }
            nameMap.put(readName, p);
        }
        if (nameMap != null && !nameMap.isEmpty()) {
            if (singletons == null) {
                singletons = nameMap.values();
            } else {
                singletons.addAll(nameMap.values());
            }
        }
        return new FragmentCollection<T>(singletons, overlapping);
    }

    public static FragmentCollection<PileupElement> create(ReadPileup rbp) {
        if (rbp == null) {
            throw new IllegalArgumentException("Pileup cannot be null");
        }
        return FragmentCollection.create(rbp::sortedIterator, rbp.size(), pileup -> pileup.getRead());
    }

    public static FragmentCollection<GATKRead> create(List<GATKRead> reads) {
        Utils.nonNull(reads);
        return FragmentCollection.create(reads, reads.size(), read -> read);
    }
}

