/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.fragments;

import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.util.QualityUtil;
import java.util.OptionalInt;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public final class FragmentUtils {
    public static final double DEFAULT_PCR_SNV_ERROR_RATE = 1.0E-4;
    public static final int DEFAULT_PCR_SNV_ERROR_QUAL = QualityUtil.getPhredScoreFromErrorProbability((double)1.0E-4);
    public static final int HALF_OF_DEFAULT_PCR_SNV_ERROR_QUAL = DEFAULT_PCR_SNV_ERROR_QUAL / 2;

    private FragmentUtils() {
    }

    public static void adjustQualsOfOverlappingPairedFragments(Pair<GATKRead, GATKRead> pair, boolean setConflictingToZero, OptionalInt halfOfPcrSnvQual, OptionalInt halfOfPcrIndelQual) {
        boolean inOrder = ((GATKRead)pair.getLeft()).getSoftStart() < ((GATKRead)pair.getRight()).getSoftStart();
        GATKRead firstRead = inOrder ? (GATKRead)pair.getLeft() : (GATKRead)pair.getRight();
        GATKRead secondRead = inOrder ? (GATKRead)pair.getRight() : (GATKRead)pair.getLeft();
        Utils.nonNull(firstRead);
        Utils.nonNull(secondRead);
        Utils.validateArg(firstRead.getName().equals(secondRead.getName()), () -> "attempting to merge two reads with different names " + firstRead + " and " + secondRead);
        if (firstRead.getEnd() < secondRead.getStart() || !firstRead.getContig().equals(secondRead.getContig())) {
            return;
        }
        Pair<Integer, CigarOperator> offsetAndOperator = ReadUtils.getReadIndexForReferenceCoordinate(firstRead, secondRead.getStart());
        CigarOperator operator = (CigarOperator)offsetAndOperator.getRight();
        int offset = (Integer)offsetAndOperator.getLeft();
        if (offset == -1 || operator.isClipping()) {
            return;
        }
        int firstReadEndBase = (Integer)ReadUtils.getReadIndexForReferenceCoordinate(firstRead, firstRead.getEnd()).getLeft();
        int secondReadEndBase = (Integer)ReadUtils.getReadIndexForReferenceCoordinate(secondRead, secondRead.getEnd()).getLeft();
        int firstReadStop = offset;
        int secondOffset = (Integer)ReadUtils.getReadIndexForReferenceCoordinate(secondRead, secondRead.getStart()).getLeft();
        int numOverlappingBases = Math.min(firstReadEndBase - firstReadStop, secondReadEndBase - secondOffset) + 1;
        byte[] firstReadBases = firstRead.getBases();
        byte[] firstReadQuals = firstRead.getBaseQualities();
        byte[] secondReadBases = secondRead.getBases();
        byte[] secondReadQuals = secondRead.getBaseQualities();
        int halfOfPcrErrorQual = halfOfPcrSnvQual.orElse(HALF_OF_DEFAULT_PCR_SNV_ERROR_QUAL);
        for (int i = 0; i < numOverlappingBases; ++i) {
            int firstReadIndex = firstReadStop + i;
            byte firstReadBase = firstReadBases[firstReadIndex];
            int secondReadIndex = secondOffset + i;
            byte secondReadBase = secondReadBases[secondReadIndex];
            if (firstReadBase == secondReadBase) {
                firstReadQuals[firstReadIndex] = (byte)Math.min(firstReadQuals[firstReadIndex], halfOfPcrErrorQual);
                secondReadQuals[secondReadIndex] = (byte)Math.min(secondReadQuals[secondReadIndex], halfOfPcrErrorQual);
                continue;
            }
            if (!setConflictingToZero) continue;
            firstReadQuals[firstReadIndex] = 0;
            secondReadQuals[secondReadIndex] = 0;
        }
        firstRead.setBaseQualities(firstReadQuals);
        secondRead.setBaseQualities(secondReadQuals);
        if (halfOfPcrIndelQual.isPresent()) {
            int maxIndelQual = halfOfPcrIndelQual.getAsInt();
            byte[] firstReadInsertionQuals = ReadUtils.getBaseInsertionQualities(firstRead);
            byte[] firstReadDeletionQuals = ReadUtils.getBaseDeletionQualities(firstRead);
            byte[] secondReadInsertionQuals = ReadUtils.getBaseInsertionQualities(secondRead);
            byte[] secondReadDeletionQuals = ReadUtils.getBaseDeletionQualities(secondRead);
            for (int i = 0; i < numOverlappingBases; ++i) {
                int firstReadIndex = firstReadStop + i;
                int secondReadIndex = secondOffset + i;
                firstReadDeletionQuals[firstReadIndex] = (byte)Math.min(firstReadDeletionQuals[firstReadIndex], maxIndelQual);
                firstReadInsertionQuals[firstReadIndex] = (byte)Math.min(firstReadInsertionQuals[firstReadIndex], maxIndelQual);
                secondReadDeletionQuals[secondReadIndex] = (byte)Math.min(secondReadDeletionQuals[secondReadIndex], maxIndelQual);
                secondReadInsertionQuals[secondReadIndex] = (byte)Math.min(secondReadInsertionQuals[secondReadIndex], maxIndelQual);
            }
            ReadUtils.setDeletionBaseQualities(firstRead, firstReadDeletionQuals);
            ReadUtils.setInsertionBaseQualities(firstRead, firstReadInsertionQuals);
            ReadUtils.setDeletionBaseQualities(secondRead, secondReadDeletionQuals);
            ReadUtils.setInsertionBaseQualities(secondRead, secondReadInsertionQuals);
        }
    }
}

