/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.genotyper;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.broadinstitute.hellbender.tools.walkers.haplotypecaller.HaplotypeCallerGenotypingDebugger;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.AlleleBiasedDownsamplingUtils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleList;
import org.broadinstitute.hellbender.utils.genotyper.IndexedAlleleList;
import org.broadinstitute.hellbender.utils.genotyper.LikelihoodMatrix;
import org.broadinstitute.hellbender.utils.genotyper.SampleList;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class AlleleLikelihoods<EVIDENCE extends Locatable, A extends Allele>
implements SampleList,
AlleleList<A> {
    public static final double LOG_10_INFORMATIVE_THRESHOLD = 0.2;
    public static final double NATURAL_LOG_INFORMATIVE_THRESHOLD = MathUtils.log10ToLog(0.2);
    protected boolean isNaturalLog = false;
    private SimpleInterval subsettedGenomicLoc;
    private static final int MISSING_INDEX = -1;
    protected final List<List<EVIDENCE>> evidenceBySampleIndex;
    protected final List<List<EVIDENCE>> filteredEvidenceBySampleIndex;
    protected final double[][][] valuesBySampleIndex;
    protected final int[] numberOfEvidences;
    protected final SampleList samples;
    protected AlleleList<A> alleles;
    protected final List<Object2IntMap<EVIDENCE>> evidenceIndexBySampleIndex;
    private int referenceAlleleIndex = -1;
    private final LikelihoodMatrix<EVIDENCE, A>[] sampleMatrices;

    private double getInformativeThreshold() {
        return this.isNaturalLog ? NATURAL_LOG_INFORMATIVE_THRESHOLD : 0.2;
    }

    public AlleleLikelihoods(SampleList samples, AlleleList<A> alleles, Map<String, List<EVIDENCE>> evidenceBySample) {
        Utils.nonNull(alleles);
        Utils.nonNull(samples);
        Utils.nonNull(evidenceBySample);
        this.samples = samples;
        this.alleles = alleles;
        int sampleCount = samples.numberOfSamples();
        int alleleCount = alleles.numberOfAlleles();
        this.evidenceBySampleIndex = new ArrayList<List<EVIDENCE>>(sampleCount);
        this.valuesBySampleIndex = new double[sampleCount][][];
        this.referenceAlleleIndex = AlleleLikelihoods.findReferenceAllele(alleles);
        this.numberOfEvidences = new int[sampleCount];
        this.evidenceIndexBySampleIndex = new ArrayList<Object>(Collections.nCopies(sampleCount, null));
        this.filteredEvidenceBySampleIndex = new ArrayList<List<EVIDENCE>>();
        this.samples().forEach(s -> this.filteredEvidenceBySampleIndex.add(new ArrayList(2)));
        this.setupIndexes(evidenceBySample, sampleCount, alleleCount);
        this.sampleMatrices = new LikelihoodMatrix[sampleCount];
    }

    AlleleLikelihoods(AlleleList alleles, SampleList samples, List<List<EVIDENCE>> evidenceBySampleIndex, List<List<EVIDENCE>> filteredEvidenceBySampleIndex, double[][][] values) {
        this.samples = samples;
        this.alleles = alleles;
        this.evidenceBySampleIndex = evidenceBySampleIndex;
        this.valuesBySampleIndex = values;
        int sampleCount = samples.numberOfSamples();
        this.evidenceIndexBySampleIndex = new ArrayList<Object>(Collections.nCopies(sampleCount, null));
        if (filteredEvidenceBySampleIndex != null) {
            this.filteredEvidenceBySampleIndex = filteredEvidenceBySampleIndex;
        } else {
            this.filteredEvidenceBySampleIndex = new ArrayList<List<EVIDENCE>>();
            this.samples().forEach(s -> this.filteredEvidenceBySampleIndex.add(new ArrayList(2)));
        }
        this.referenceAlleleIndex = AlleleLikelihoods.findReferenceAllele(alleles);
        this.sampleMatrices = new LikelihoodMatrix[sampleCount];
        this.numberOfEvidences = IntStream.range(0, sampleCount).map(i -> ((List)evidenceBySampleIndex.get(i)).size()).toArray();
    }

    private void setupIndexes(Map<String, List<EVIDENCE>> evidenceBySample, int sampleCount, int alleleCount) {
        for (int s = 0; s < sampleCount; ++s) {
            String sample = this.samples.getSample(s);
            List<EVIDENCE> sampleEvidences = evidenceBySample.get(sample);
            this.numberOfEvidences[s] = sampleEvidences == null ? 0 : sampleEvidences.size();
            this.evidenceBySampleIndex.add(sampleEvidences == null ? new ArrayList() : new ArrayList<EVIDENCE>(sampleEvidences));
            int sampleEvidenceCount = this.evidenceBySampleIndex.get(s).size();
            double[][] sampleValues = new double[alleleCount][sampleEvidenceCount];
            this.valuesBySampleIndex[s] = sampleValues;
        }
    }

    private static int findReferenceAllele(AlleleList<?> alleles) {
        return IntStream.range(0, alleles.numberOfAlleles()).filter(i -> alleles.getAllele(i).isReference()).findAny().orElse(-1);
    }

    @Override
    public int indexOfSample(String sample) {
        return this.samples.indexOfSample(sample);
    }

    @Override
    public int numberOfSamples() {
        return this.samples.numberOfSamples();
    }

    @Override
    public String getSample(int sampleIndex) {
        return this.samples.getSample(sampleIndex);
    }

    @Override
    public int indexOfAllele(A allele) {
        return this.alleles.indexOfAllele(allele);
    }

    @Override
    public int numberOfAlleles() {
        return this.alleles.numberOfAlleles();
    }

    @Override
    public A getAllele(int alleleIndex) {
        return this.alleles.getAllele(alleleIndex);
    }

    public List<EVIDENCE> sampleEvidence(int sampleIndex) {
        return Collections.unmodifiableList(this.evidenceBySampleIndex.get(sampleIndex));
    }

    public List<EVIDENCE> filteredSampleEvidence(int sampleIndex) {
        return Collections.unmodifiableList(this.filteredEvidenceBySampleIndex.get(sampleIndex));
    }

    public LikelihoodMatrix<EVIDENCE, A> sampleMatrix(int sampleIndex) {
        Utils.validIndex(sampleIndex, this.samples.numberOfSamples());
        LikelihoodMatrix<EVIDENCE, A> extantResult = this.sampleMatrices[sampleIndex];
        if (extantResult == null) {
            this.sampleMatrices[sampleIndex] = new SampleMatrix(sampleIndex);
            return this.sampleMatrices[sampleIndex];
        }
        return extantResult;
    }

    public void switchToNaturalLog() {
        Utils.validate(!this.isNaturalLog, "Likelihoods have already been switched to natural log");
        int sampleCount = this.samples.numberOfSamples();
        int alleleCount = this.alleles.numberOfAlleles();
        for (int s = 0; s < sampleCount; ++s) {
            int evidenceCount = this.sampleEvidenceCount(s);
            for (int a = 0; a < alleleCount; ++a) {
                for (int e = 0; e < evidenceCount; ++e) {
                    this.valuesBySampleIndex[s][a][e] = MathUtils.log10ToLog(this.valuesBySampleIndex[s][a][e]);
                }
            }
        }
        this.isNaturalLog = true;
    }

    public void contaminationDownsampling(Map<String, Double> perSampleDownsamplingFraction) {
        Utils.nonNull(perSampleDownsamplingFraction);
        int alleleCount = this.alleles.numberOfAlleles();
        for (int s = 0; s < this.samples.numberOfSamples(); ++s) {
            double fraction = perSampleDownsamplingFraction.getOrDefault(this.samples.getSample(s), 0.0);
            if (Double.isNaN(fraction) || fraction <= 0.0) continue;
            Map<A, List<EVIDENCE>> alleleEvidenceMap = this.evidenceByBestAlleleMap(s);
            List<EVIDENCE> evidenceToRemove = fraction >= 1.0 ? (Collection)this.evidenceBySampleIndex.get(s) : AlleleBiasedDownsamplingUtils.selectAlleleBiasedEvidence(alleleEvidenceMap, fraction);
            this.removeEvidence(s, evidenceToRemove);
        }
    }

    public void normalizeLikelihoods(double maximumLikelihoodDifferenceCap, boolean symmetricallyNormalizeAllelesToReference) {
        Utils.validateArg(maximumLikelihoodDifferenceCap < 0.0 && !Double.isNaN(maximumLikelihoodDifferenceCap), "the minimum reference likelihood fall must be negative");
        if (maximumLikelihoodDifferenceCap == Double.NEGATIVE_INFINITY) {
            return;
        }
        int alleleCount = this.alleles.numberOfAlleles();
        if (alleleCount == 0) {
            return;
        }
        if (alleleCount == 1) {
            return;
        }
        for (int s = 0; s < this.valuesBySampleIndex.length; ++s) {
            double[][] sampleValues = this.valuesBySampleIndex[s];
            int evidenceCount = this.evidenceBySampleIndex.get(s).size();
            for (int r = 0; r < evidenceCount; ++r) {
                this.normalizeLikelihoodsPerEvidence(maximumLikelihoodDifferenceCap, sampleValues, s, r, symmetricallyNormalizeAllelesToReference);
            }
        }
    }

    private void normalizeLikelihoodsPerEvidence(double maximumBestAltLikelihoodDifference, double[][] sampleValues, int sampleIndex, int evidenceIndex, boolean symmetricallyNormalizeAllelesToReference) {
        BestAllele bestAllele = this.searchBestAllele(sampleIndex, evidenceIndex, symmetricallyNormalizeAllelesToReference);
        double worstLikelihoodCap = bestAllele.likelihood + maximumBestAltLikelihoodDifference;
        int alleleCount = this.alleles.numberOfAlleles();
        for (int a = 0; a < alleleCount; ++a) {
            if (!(sampleValues[a][evidenceIndex] < worstLikelihoodCap)) continue;
            sampleValues[a][evidenceIndex] = worstLikelihoodCap;
        }
    }

    public List<String> samples() {
        return this.samples.asListOfSamples();
    }

    public List<A> alleles() {
        return this.alleles.asListOfAlleles();
    }

    private BestAllele searchBestAllele(int sampleIndex, int evidenceIndex, boolean canBeReference, Optional<double[]> priorities) {
        int alleleCount = this.alleles.numberOfAlleles();
        if (alleleCount == 0 || alleleCount == 1 && this.referenceAlleleIndex == 0 && !canBeReference) {
            return new BestAllele(sampleIndex, evidenceIndex, -1, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        }
        double[][] sampleValues = this.valuesBySampleIndex[sampleIndex];
        int bestAlleleIndex = canBeReference || this.referenceAlleleIndex != 0 ? 0 : 1;
        int secondBestIndex = 0;
        double bestLikelihood = sampleValues[bestAlleleIndex][evidenceIndex];
        double secondBestLikelihood = Double.NEGATIVE_INFINITY;
        for (int a = bestAlleleIndex + 1; a < alleleCount; ++a) {
            if (!canBeReference && this.referenceAlleleIndex == a) continue;
            double candidateLikelihood = sampleValues[a][evidenceIndex];
            if (candidateLikelihood > bestLikelihood) {
                secondBestIndex = bestAlleleIndex;
                bestAlleleIndex = a;
                secondBestLikelihood = bestLikelihood;
                bestLikelihood = candidateLikelihood;
                continue;
            }
            if (!(candidateLikelihood > secondBestLikelihood)) continue;
            secondBestIndex = a;
            secondBestLikelihood = candidateLikelihood;
        }
        if (priorities.isPresent() && bestLikelihood - secondBestLikelihood < this.getInformativeThreshold()) {
            double bestPriority = priorities.get()[bestAlleleIndex];
            double secondBestPriority = priorities.get()[secondBestIndex];
            for (int a = 0; a < alleleCount; ++a) {
                double candidateLikelihood = sampleValues[a][evidenceIndex];
                if (a == bestAlleleIndex || !canBeReference && a == this.referenceAlleleIndex || bestLikelihood - candidateLikelihood > this.getInformativeThreshold()) continue;
                double candidatePriority = priorities.get()[a];
                if (candidatePriority > bestPriority) {
                    secondBestIndex = bestAlleleIndex;
                    bestAlleleIndex = a;
                    secondBestPriority = bestPriority;
                    bestPriority = candidatePriority;
                    continue;
                }
                if (!(candidatePriority > secondBestPriority)) continue;
                secondBestIndex = a;
                secondBestPriority = candidatePriority;
            }
        }
        bestLikelihood = sampleValues[bestAlleleIndex][evidenceIndex];
        secondBestLikelihood = secondBestIndex != bestAlleleIndex ? sampleValues[secondBestIndex][evidenceIndex] : Double.NEGATIVE_INFINITY;
        return new BestAllele(sampleIndex, evidenceIndex, bestAlleleIndex, bestLikelihood, secondBestLikelihood);
    }

    private BestAllele searchBestAllele(int sampleIndex, int evidenceIndex, boolean canBeReference) {
        return this.searchBestAllele(sampleIndex, evidenceIndex, canBeReference, Optional.empty());
    }

    public void changeEvidence(Map<EVIDENCE, EVIDENCE> evidenceReplacements) {
        int sampleCount = this.samples.numberOfSamples();
        for (int s = 0; s < sampleCount; ++s) {
            List<EVIDENCE> sampleEvidence = this.evidenceBySampleIndex.get(s);
            Object2IntMap<EVIDENCE> evidenceIndex = this.evidenceIndexBySampleIndex.get(s);
            int sampleEvidenceCount = sampleEvidence.size();
            for (int r = 0; r < sampleEvidenceCount; ++r) {
                Locatable evidence = (Locatable)sampleEvidence.get(r);
                Locatable replacement = (Locatable)evidenceReplacements.get(evidence);
                if (replacement == null) continue;
                sampleEvidence.set(r, replacement);
                if (evidenceIndex == null) continue;
                evidenceIndex.remove((Object)evidence);
                evidenceIndex.put((Object)replacement, r);
            }
        }
    }

    public boolean addMissingAlleles(Collection<A> candidateAlleles, double defaultLikelihood) {
        Utils.nonNull(candidateAlleles, "the candidateAlleles list cannot be null");
        if (candidateAlleles.isEmpty()) {
            return false;
        }
        List allelesToAdd = candidateAlleles.stream().filter(allele -> !this.alleles.containsAllele((Allele)allele)).collect(Collectors.toList());
        if (allelesToAdd.isEmpty()) {
            return false;
        }
        int oldAlleleCount = this.alleles.numberOfAlleles();
        int newAlleleCount = this.alleles.numberOfAlleles() + allelesToAdd.size();
        int referenceIndex = this.referenceAlleleIndex;
        List newAlleles = ListUtils.union(this.alleles.asListOfAlleles(), allelesToAdd);
        this.alleles = new IndexedAlleleList(newAlleles);
        OptionalInt indexOfReferenceInAllelesToAdd = IntStream.range(0, allelesToAdd.size()).filter(n -> ((Allele)allelesToAdd.get(n)).isReference()).findFirst();
        if (referenceIndex != -1) {
            Utils.validateArg(!indexOfReferenceInAllelesToAdd.isPresent(), "there can only be one reference allele");
        } else if (indexOfReferenceInAllelesToAdd.isPresent()) {
            this.referenceAlleleIndex = oldAlleleCount + indexOfReferenceInAllelesToAdd.getAsInt();
        }
        for (int s = 0; s < this.samples.numberOfSamples(); ++s) {
            int sampleEvidenceCount = this.evidenceBySampleIndex.get(s).size();
            double[][] newValuesBySampleIndex = (double[][])Arrays.copyOf(this.valuesBySampleIndex[s], newAlleleCount);
            for (int a = oldAlleleCount; a < newAlleleCount; ++a) {
                newValuesBySampleIndex[a] = new double[sampleEvidenceCount];
                if (defaultLikelihood == 0.0) continue;
                Arrays.fill(newValuesBySampleIndex[a], defaultLikelihood);
            }
            this.valuesBySampleIndex[s] = newValuesBySampleIndex;
        }
        return true;
    }

    public <U, NEW_EVIDENCE_TYPE extends Locatable> AlleleLikelihoods<NEW_EVIDENCE_TYPE, A> groupEvidence(Function<EVIDENCE, U> groupingFunction, Function<List<EVIDENCE>, NEW_EVIDENCE_TYPE> gather) {
        int sampleCount = this.samples.numberOfSamples();
        double[][][] newLikelihoodValues = new double[sampleCount][][];
        int alleleCount = this.alleles.numberOfAlleles();
        ArrayList<List<EVIDENCE>> newEvidenceBySampleIndex = new ArrayList<List<EVIDENCE>>(sampleCount);
        for (int s = 0; s < sampleCount; ++s) {
            ArrayList<List<EVIDENCE>> evidenceGroups = new ArrayList<List<EVIDENCE>>(this.sampleEvidence(s).stream().collect(Collectors.groupingBy(groupingFunction)).values());
            int newEvidenceCount = evidenceGroups.size();
            double[][] oldSampleValues = this.valuesBySampleIndex[s];
            newLikelihoodValues[s] = new double[alleleCount][newEvidenceCount];
            for (int newEvidenceIndex = 0; newEvidenceIndex < newEvidenceCount; ++newEvidenceIndex) {
                for (int a = 0; a < alleleCount; ++a) {
                    for (Locatable evidence : (List)evidenceGroups.get(newEvidenceIndex)) {
                        int oldEvidenceIndex = this.evidenceIndex(s, evidence);
                        double[] dArray = newLikelihoodValues[s][a];
                        int n = newEvidenceIndex;
                        dArray[n] = dArray[n] + oldSampleValues[a][oldEvidenceIndex];
                    }
                }
            }
            newEvidenceBySampleIndex.add(evidenceGroups.stream().map(gather).collect(Collectors.toList()));
        }
        AlleleLikelihoods<EVIDENCE, A> result = new AlleleLikelihoods<EVIDENCE, A>(this.alleles, this.samples, newEvidenceBySampleIndex, null, newLikelihoodValues);
        result.isNaturalLog = this.isNaturalLog;
        return result;
    }

    public <B extends Allele> AlleleLikelihoods<EVIDENCE, B> marginalize(Map<B, List<A>> newToOldAlleleMap) {
        Utils.nonNull(newToOldAlleleMap);
        Allele[] newAlleles = newToOldAlleleMap.keySet().toArray(new Allele[newToOldAlleleMap.size()]);
        int oldAlleleCount = this.alleles.numberOfAlleles();
        int newAlleleCount = newAlleles.length;
        int[] oldToNewAlleleIndexMap = this.oldToNewAlleleIndexMap(newToOldAlleleMap, oldAlleleCount, newAlleles);
        double[][][] newLikelihoodValues = this.marginalLikelihoods(oldAlleleCount, newAlleleCount, oldToNewAlleleIndexMap);
        int sampleCount = this.samples.numberOfSamples();
        ArrayList<List<EVIDENCE>> newEvidenceBySampleIndex = new ArrayList<List<EVIDENCE>>(sampleCount);
        for (int s = 0; s < sampleCount; ++s) {
            newEvidenceBySampleIndex.add(new ArrayList(this.evidenceBySampleIndex.get(s)));
        }
        AlleleLikelihoods<EVIDENCE, A> result = new AlleleLikelihoods<EVIDENCE, A>(new IndexedAlleleList(newAlleles), this.samples, newEvidenceBySampleIndex, this.filteredEvidenceBySampleIndex, newLikelihoodValues);
        result.isNaturalLog = this.isNaturalLog;
        return result;
    }

    private double[][][] marginalLikelihoods(int oldAlleleCount, int newAlleleCount, int[] oldToNewAlleleIndexMap) {
        int sampleCount = this.samples.numberOfSamples();
        double[][][] result = new double[sampleCount][][];
        for (int s = 0; s < sampleCount; ++s) {
            int sampleEvidenceCount = this.evidenceBySampleIndex.get(s).size();
            double[][] oldSampleValues = this.valuesBySampleIndex[s];
            double[][] newSampleValues = result[s] = new double[newAlleleCount][sampleEvidenceCount];
            for (int a = 0; a < newAlleleCount; ++a) {
                Arrays.fill(newSampleValues[a], Double.NEGATIVE_INFINITY);
            }
            for (int r = 0; r < sampleEvidenceCount; ++r) {
                for (int a = 0; a < oldAlleleCount; ++a) {
                    double likelihood;
                    int newAlleleIndex = oldToNewAlleleIndexMap[a];
                    if (newAlleleIndex == -1 || !((likelihood = oldSampleValues[a][r]) > newSampleValues[newAlleleIndex][r])) continue;
                    newSampleValues[newAlleleIndex][r] = likelihood;
                }
            }
        }
        return result;
    }

    private <B extends Allele> int[] oldToNewAlleleIndexMap(Map<B, List<A>> newToOldAlleleMap, int oldAlleleCount, B[] newAlleles) {
        Arrays.stream(newAlleles).forEach(Utils::nonNull);
        Utils.containsNoNull(newToOldAlleleMap.values(), "no new allele list can be null");
        newToOldAlleleMap.values().stream().forEach(oldList -> Utils.containsNoNull(oldList, "old alleles cannot be null"));
        int[] oldToNewAlleleIndexMap = new int[oldAlleleCount];
        Arrays.fill(oldToNewAlleleIndexMap, -1);
        for (int newIndex = 0; newIndex < newAlleles.length; ++newIndex) {
            B newAllele = newAlleles[newIndex];
            for (Allele oldAllele : newToOldAlleleMap.get(newAllele)) {
                int oldAlleleIndex = this.indexOfAllele(oldAllele);
                if (oldAlleleIndex == -1) {
                    throw new IllegalArgumentException("missing old allele " + oldAllele + " in likelihood collection ");
                }
                if (oldToNewAlleleIndexMap[oldAlleleIndex] != -1) {
                    throw new IllegalArgumentException("collision: two new alleles make reference to the same old allele");
                }
                oldToNewAlleleIndexMap[oldAlleleIndex] = newIndex;
            }
        }
        return oldToNewAlleleIndexMap;
    }

    public void addEvidence(Map<String, List<EVIDENCE>> evidenceBySample, double initialLikelihood) {
        for (Map.Entry<String, List<EVIDENCE>> entry : evidenceBySample.entrySet()) {
            String sample = entry.getKey();
            List<EVIDENCE> newSampleEvidence = entry.getValue();
            int sampleIndex = this.samples.indexOfSample(sample);
            if (sampleIndex == -1) {
                throw new IllegalArgumentException("input sample " + sample + " is not part of the evidence-likelihoods collection");
            }
            if (newSampleEvidence == null || newSampleEvidence.isEmpty()) continue;
            int oldEvidenceCount = this.evidenceBySampleIndex.get(sampleIndex).size();
            this.appendEvidence(newSampleEvidence, sampleIndex);
            int newEvidenceCount = this.evidenceBySampleIndex.get(sampleIndex).size();
            this.extendsLikelihoodArrays(initialLikelihood, sampleIndex, oldEvidenceCount, newEvidenceCount);
        }
    }

    private void extendsLikelihoodArrays(double initialLikelihood, int sampleIndex, int sampleEvidenceCount, int newSampleEvidenceCount) {
        int a;
        double[][] sampleValues = this.valuesBySampleIndex[sampleIndex];
        int alleleCount = this.alleles.numberOfAlleles();
        for (a = 0; a < alleleCount; ++a) {
            sampleValues[a] = sampleValues[a].length < newSampleEvidenceCount ? Arrays.copyOf(sampleValues[a], newSampleEvidenceCount) : sampleValues[a];
        }
        if (initialLikelihood != 0.0) {
            for (a = 0; a < alleleCount; ++a) {
                Arrays.fill(sampleValues[a], sampleEvidenceCount, newSampleEvidenceCount, initialLikelihood);
            }
        }
    }

    private void appendEvidence(List<EVIDENCE> newSampleEvidence, int sampleIndex) {
        List<EVIDENCE> sampleEvidence = this.evidenceBySampleIndex.get(sampleIndex);
        Object2IntMap<EVIDENCE> sampleEvidenceIndex = this.evidenceIndexBySampleIndex(sampleIndex);
        for (Locatable newEvidence : newSampleEvidence) {
            int previousValue = sampleEvidenceIndex.put((Object)newEvidence, sampleEvidence.size());
            if (previousValue == -1) {
                sampleEvidence.add(newEvidence);
                continue;
            }
            sampleEvidenceIndex.put((Object)newEvidence, previousValue);
        }
        this.numberOfEvidences[sampleIndex] = sampleEvidence.size();
    }

    public void addNonReferenceAllele(A nonRefAllele) {
        Utils.nonNull(nonRefAllele, "non-ref allele cannot be null");
        if (!nonRefAllele.equals((Object)Allele.NON_REF_ALLELE)) {
            throw new IllegalArgumentException("the non-ref allele is not valid");
        }
        if (this.alleles.containsAllele(nonRefAllele)) {
            return;
        }
        if (this.addMissingAlleles(Collections.singleton(nonRefAllele), Double.NEGATIVE_INFINITY)) {
            this.updateNonRefAlleleLikelihoods();
        }
    }

    public void updateNonRefAlleleLikelihoods() {
        this.updateNonRefAlleleLikelihoods(this.alleles);
    }

    public void updateNonRefAlleleLikelihoods(AlleleList<A> allelesToConsider) {
        int nonRefAlleleIndex = this.indexOfAllele(Allele.NON_REF_ALLELE);
        if (nonRefAlleleIndex < 0) {
            return;
        }
        int alleleCount = this.alleles.numberOfAlleles();
        int nonSymbolicAlleleCount = alleleCount - 1;
        double[] qualifiedAlleleLikelihoods = new double[nonSymbolicAlleleCount];
        Median medianCalculator = new Median();
        for (int s = 0; s < this.samples.numberOfSamples(); ++s) {
            double[][] sampleValues = this.valuesBySampleIndex[s];
            int evidenceCount = this.evidenceBySampleIndex.get(s).size();
            for (int r = 0; r < evidenceCount; ++r) {
                BestAllele bestAllele = this.searchBestAllele(s, r, true);
                int numberOfQualifiedAlleleLikelihoods = 0;
                for (int i = 0; i < alleleCount; ++i) {
                    double alleleLikelihood = sampleValues[i][r];
                    if (i == nonRefAlleleIndex || !(alleleLikelihood < bestAllele.likelihood) || Double.isNaN(alleleLikelihood) || allelesToConsider.indexOfAllele(this.alleles.getAllele(i)) == -1) continue;
                    qualifiedAlleleLikelihoods[numberOfQualifiedAlleleLikelihoods++] = alleleLikelihood;
                }
                double nonRefLikelihood = medianCalculator.evaluate(qualifiedAlleleLikelihoods, 0, numberOfQualifiedAlleleLikelihoods);
                sampleValues[nonRefAlleleIndex][r] = !Double.isNaN(nonRefLikelihood) ? nonRefLikelihood : (nonSymbolicAlleleCount <= 1 ? Double.NaN : bestAllele.likelihood);
            }
        }
    }

    public Collection<BestAllele> bestAllelesBreakingTies(Function<A, Double> tieBreakingPriority) {
        return IntStream.range(0, this.numberOfSamples()).boxed().flatMap(n -> this.bestAllelesBreakingTies((int)n, tieBreakingPriority).stream()).collect(Collectors.toList());
    }

    public Collection<BestAllele> bestAllelesBreakingTies() {
        return IntStream.range(0, this.numberOfSamples()).boxed().flatMap(n -> this.bestAllelesBreakingTies((int)n).stream()).collect(Collectors.toList());
    }

    public Collection<BestAllele> bestAllelesBreakingTies(String sample, Function<A, Double> tieBreakingPriority) {
        int sampleIndex = this.indexOfSample(sample);
        return this.bestAllelesBreakingTies(sampleIndex, tieBreakingPriority);
    }

    public Collection<BestAllele> bestAllelesBreakingTies(String sample) {
        int sampleIndex = this.indexOfSample(sample);
        return this.bestAllelesBreakingTies(sampleIndex);
    }

    private Collection<BestAllele> bestAllelesBreakingTies(int sampleIndex, Function<A, Double> tieBreakingPriority) {
        Utils.validIndex(sampleIndex, this.numberOfSamples());
        Optional<double[]> priorities = this.alleles == null ? Optional.empty() : Optional.of(this.alleles.asListOfAlleles().stream().mapToDouble(tieBreakingPriority::apply).toArray());
        int evidenceCount = this.evidenceBySampleIndex.get(sampleIndex).size();
        ArrayList<BestAllele> result = new ArrayList<BestAllele>(evidenceCount);
        for (int r = 0; r < evidenceCount; ++r) {
            result.add(this.searchBestAllele(sampleIndex, r, true, priorities));
        }
        return result;
    }

    private Collection<BestAllele> bestAllelesBreakingTies(int sampleIndex) {
        return this.bestAllelesBreakingTies(sampleIndex, (A a) -> a.isReference() ? 1.0 : 0.0);
    }

    protected Map<A, List<EVIDENCE>> evidenceByBestAlleleMap(int sampleIndex) {
        Utils.validIndex(sampleIndex, this.numberOfSamples());
        int alleleCount = this.alleles.numberOfAlleles();
        int sampleEvidenceCount = this.evidenceBySampleIndex.get(sampleIndex).size();
        LinkedHashMap result = new LinkedHashMap(alleleCount);
        for (int a = 0; a < alleleCount; ++a) {
            result.put(this.alleles.getAllele(a), new ArrayList(sampleEvidenceCount));
        }
        this.evidenceByBestAlleleMap(sampleIndex, result);
        return result;
    }

    @VisibleForTesting
    Map<A, List<EVIDENCE>> evidenceByBestAlleleMap() {
        int alleleCount = this.alleles.numberOfAlleles();
        LinkedHashMap result = new LinkedHashMap(alleleCount);
        int totalEvidenceCount = this.evidenceCount();
        for (int a = 0; a < alleleCount; ++a) {
            result.put(this.alleles.getAllele(a), new ArrayList(totalEvidenceCount));
        }
        int sampleCount = this.samples.numberOfSamples();
        for (int s = 0; s < sampleCount; ++s) {
            this.evidenceByBestAlleleMap(s, result);
        }
        return result;
    }

    private void evidenceByBestAlleleMap(int sampleIndex, Map<A, List<EVIDENCE>> result) {
        int evidenceCount = this.evidenceBySampleIndex.get(sampleIndex).size();
        for (int r = 0; r < evidenceCount; ++r) {
            BestAllele bestAllele = this.searchBestAllele(sampleIndex, r, true);
            if (!bestAllele.isInformative()) continue;
            result.get(bestAllele.allele).add(bestAllele.evidence);
        }
    }

    @VisibleForTesting
    int evidenceIndex(int sampleIndex, EVIDENCE evidence) {
        Object2IntMap<EVIDENCE> index = this.evidenceIndexBySampleIndex(sampleIndex);
        return index.getInt(evidence);
    }

    public int evidenceCount() {
        return this.evidenceBySampleIndex.stream().mapToInt(List::size).sum();
    }

    public int sampleEvidenceCount(int sampleIndex) {
        Utils.validIndex(sampleIndex, this.samples.numberOfSamples());
        return this.evidenceBySampleIndex.get(sampleIndex).size();
    }

    public void retainEvidence(Predicate<? super EVIDENCE> predicate) {
        Utils.nonNull(predicate);
        int sampleCount = this.samples.numberOfSamples();
        for (int s = 0; s < sampleCount; ++s) {
            List sampleEvidence = this.evidenceBySampleIndex.get(s);
            int[] removeIndices = IntStream.range(0, sampleEvidence.size()).filter(i -> !predicate.test((Object)sampleEvidence.get(i))).toArray();
            this.removeEvidenceByIndex(s, removeIndices);
            List sampleFiltered = this.filteredEvidenceBySampleIndex.get(s).stream().filter(e -> predicate.test((Object)e)).collect(Collectors.toList());
            this.filteredEvidenceBySampleIndex.set(s, sampleFiltered);
        }
    }

    protected double maximumLikelihoodOverAllAlleles(int sampleIndex, int evidenceIndex) {
        double result = Double.NEGATIVE_INFINITY;
        int alleleCount = this.alleles.numberOfAlleles();
        double[][] sampleValues = this.valuesBySampleIndex[sampleIndex];
        for (int a = 0; a < alleleCount; ++a) {
            if (!(sampleValues[a][evidenceIndex] > result)) continue;
            result = sampleValues[a][evidenceIndex];
        }
        return result;
    }

    public void setVariantCallingSubsetUsed(SimpleInterval loc) {
        this.subsettedGenomicLoc = loc;
    }

    public SimpleInterval getVariantCallingSubsetApplied() {
        return this.subsettedGenomicLoc;
    }

    private void removeEvidence(int sampleIndex, Collection<EVIDENCE> evidences) {
        Object2IntMap evidenceIndexes = this.evidenceIndexBySampleIndex(sampleIndex);
        int[] indexesToRemove = evidences.stream().mapToInt(e -> {
            int index = evidenceIndexes.getInt(e);
            if (index == -1) {
                throw new IllegalArgumentException("evidence provided is not in sample");
            }
            return index;
        }).sorted().distinct().toArray();
        this.removeEvidenceByIndex(sampleIndex, indexesToRemove);
    }

    private void removeEvidenceByIndex(int sampleIndex, int[] evidencesToRemove) {
        int numToRemove = evidencesToRemove.length;
        if (numToRemove == 0) {
            return;
        }
        int oldEvidenceCount = this.numberOfEvidences[sampleIndex];
        int newEvidenceCount = oldEvidenceCount - evidencesToRemove.length;
        List<EVIDENCE> oldEvidence = this.evidenceBySampleIndex.get(sampleIndex);
        ArrayList<EVIDENCE> newEvidence = new ArrayList<EVIDENCE>(newEvidenceCount);
        int numRemoved = 0;
        for (int n = 0; n < oldEvidenceCount; ++n) {
            if (numRemoved < numToRemove && n == evidencesToRemove[numRemoved]) {
                ++numRemoved;
                continue;
            }
            newEvidence.add(oldEvidence.get(n));
            for (double[] alleleValues : this.valuesBySampleIndex[sampleIndex]) {
                alleleValues[n - numRemoved] = alleleValues[n];
            }
        }
        this.evidenceBySampleIndex.set(sampleIndex, newEvidence);
        this.numberOfEvidences[sampleIndex] = newEvidenceCount;
        this.invalidateEvidenceToIndexCache(sampleIndex);
    }

    private void invalidateEvidenceToIndexCache(int sampleIndex) {
        this.evidenceIndexBySampleIndex.set(sampleIndex, null);
    }

    @VisibleForTesting
    public void filterPoorlyModeledEvidence(ToDoubleFunction<EVIDENCE> log10MinTrueLikelihood) {
        Utils.validateArg(this.alleles.numberOfAlleles() > 0, "unsupported for read-likelihood collections with no alleles");
        int numberOfSamples = this.samples.numberOfSamples();
        for (int s = 0; s < numberOfSamples; ++s) {
            int sampleIndex = s;
            List<EVIDENCE> sampleEvidence = this.evidenceBySampleIndex.get(s);
            ArrayList evidenceToRemove = new ArrayList(sampleEvidence.size());
            int numberOfEvidence = sampleEvidence.size();
            int[] indexesToRemove = IntStream.range(0, numberOfEvidence).filter(i -> this.maximumLikelihoodOverAllAlleles(sampleIndex, i) < log10MinTrueLikelihood.applyAsDouble(sampleEvidence.get(i))).toArray();
            List<EVIDENCE> filtered = this.filteredEvidenceBySampleIndex.get(sampleIndex);
            Arrays.stream(indexesToRemove).forEach(idx -> {
                if (HaplotypeCallerGenotypingDebugger.isEnabled()) {
                    HaplotypeCallerGenotypingDebugger.println("disqualified read: " + idx + " " + ((GATKRead)sampleEvidence.get(idx)).getName() + " with max likelihood " + this.maximumLikelihoodOverAllAlleles(sampleIndex, idx) + " and threshold " + log10MinTrueLikelihood.applyAsDouble(sampleEvidence.get(idx)));
                }
                filtered.add(sampleEvidence.get(idx));
            });
            this.removeEvidenceByIndex(s, indexesToRemove);
        }
    }

    private Object2IntMap<EVIDENCE> evidenceIndexBySampleIndex(int sampleIndex) {
        Object2IntMap<EVIDENCE> cached = this.evidenceIndexBySampleIndex.get(sampleIndex);
        return cached == null ? this.fillEvidenceToIndexCache(sampleIndex) : cached;
    }

    private Object2IntMap<EVIDENCE> fillEvidenceToIndexCache(int sampleIndex) {
        List<EVIDENCE> sampleEvidence = this.evidenceBySampleIndex.get(sampleIndex);
        int sampleEvidenceCount = sampleEvidence.size();
        Object2IntOpenHashMap index = new Object2IntOpenHashMap(sampleEvidenceCount);
        index.defaultReturnValue(-1);
        for (int r = 0; r < sampleEvidenceCount; ++r) {
            index.put(sampleEvidence.get(r), r);
        }
        this.evidenceIndexBySampleIndex.set(sampleIndex, (Object2IntMap<EVIDENCE>)index);
        return index;
    }

    private final class SampleMatrix
    implements LikelihoodMatrix<EVIDENCE, A> {
        private final int sampleIndex;

        private SampleMatrix(int sampleIndex) {
            this.sampleIndex = sampleIndex;
        }

        @Override
        public List<EVIDENCE> evidence() {
            return AlleleLikelihoods.this.sampleEvidence(this.sampleIndex);
        }

        @Override
        public List<A> alleles() {
            return AlleleLikelihoods.this.alleles();
        }

        @Override
        public void set(int alleleIndex, int evidenceIndex, double value) {
            Utils.validIndex(alleleIndex, AlleleLikelihoods.this.valuesBySampleIndex[this.sampleIndex].length);
            Utils.validIndex(evidenceIndex, AlleleLikelihoods.this.numberOfEvidences[this.sampleIndex]);
            AlleleLikelihoods.this.valuesBySampleIndex[this.sampleIndex][alleleIndex][evidenceIndex] = value;
        }

        @Override
        public double get(int alleleIndex, int evidenceIndex) {
            Utils.validIndex(alleleIndex, AlleleLikelihoods.this.valuesBySampleIndex[this.sampleIndex].length);
            Utils.validIndex(evidenceIndex, AlleleLikelihoods.this.numberOfEvidences[this.sampleIndex]);
            return AlleleLikelihoods.this.valuesBySampleIndex[this.sampleIndex][alleleIndex][evidenceIndex];
        }

        @Override
        public int indexOfAllele(A allele) {
            Utils.nonNull(allele);
            return AlleleLikelihoods.this.indexOfAllele(allele);
        }

        @Override
        public int indexOfEvidence(EVIDENCE evidence) {
            Utils.nonNull(evidence);
            return AlleleLikelihoods.this.evidenceIndex(this.sampleIndex, evidence);
        }

        @Override
        public int numberOfAlleles() {
            return AlleleLikelihoods.this.alleles.numberOfAlleles();
        }

        @Override
        public int evidenceCount() {
            return AlleleLikelihoods.this.numberOfEvidences[this.sampleIndex];
        }

        @Override
        public A getAllele(int alleleIndex) {
            return AlleleLikelihoods.this.getAllele(alleleIndex);
        }

        @Override
        public EVIDENCE getEvidence(int evidenceIndex) {
            List sampleEvidence = AlleleLikelihoods.this.evidenceBySampleIndex.get(this.sampleIndex);
            Utils.validIndex(evidenceIndex, sampleEvidence.size());
            return (Locatable)sampleEvidence.get(evidenceIndex);
        }

        @Override
        public void copyAlleleLikelihoods(int alleleIndex, double[] dest, int offset) {
            Utils.nonNull(dest);
            Utils.validIndex(alleleIndex, AlleleLikelihoods.this.valuesBySampleIndex[this.sampleIndex].length);
            System.arraycopy(AlleleLikelihoods.this.valuesBySampleIndex[this.sampleIndex][alleleIndex], 0, dest, offset, AlleleLikelihoods.this.numberOfEvidences[this.sampleIndex]);
        }
    }

    public final class BestAllele {
        public final A allele;
        public final String sample;
        public final EVIDENCE evidence;
        public final double likelihood;
        public final double confidence;

        private BestAllele(int sampleIndex, int evidenceIndex, int bestAlleleIndex, double likelihood, double secondBestLikelihood) {
            this.allele = bestAlleleIndex == -1 ? null : AlleleLikelihoods.this.alleles.getAllele(bestAlleleIndex);
            this.likelihood = likelihood;
            this.sample = AlleleLikelihoods.this.samples.getSample(sampleIndex);
            this.evidence = (Locatable)AlleleLikelihoods.this.evidenceBySampleIndex.get(sampleIndex).get(evidenceIndex);
            this.confidence = likelihood == secondBestLikelihood ? 0.0 : likelihood - secondBestLikelihood;
        }

        public boolean isInformative() {
            return this.confidence > 0.2;
        }
    }
}

