/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.genotyper;

import htsjdk.variant.variantcontext.Allele;
import java.util.AbstractList;
import java.util.List;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleListPermutation;
import org.broadinstitute.hellbender.utils.genotyper.IndexedAlleleList;

public interface AlleleList<A extends Allele> {
    public static final AlleleList EMPTY_LIST = new AlleleList(){

        @Override
        public int numberOfAlleles() {
            return 0;
        }

        public int indexOfAllele(Allele allele) {
            Utils.nonNull(allele);
            return -1;
        }

        public Allele getAllele(int index) {
            throw new IllegalArgumentException("allele index is out of range");
        }
    };

    public static <A extends Allele> AlleleList<A> newList(List<A> alleles) {
        return new IndexedAlleleList<A>(alleles);
    }

    public int numberOfAlleles();

    public int indexOfAllele(A var1);

    public A getAllele(int var1);

    default public boolean containsAllele(A allele) {
        return this.indexOfAllele(allele) >= 0;
    }

    public static <A extends Allele> AlleleList<A> emptyAlleleList() {
        return EMPTY_LIST;
    }

    public static <A extends Allele> boolean equals(AlleleList<A> first, AlleleList<A> second) {
        if (first == null || second == null) {
            throw new IllegalArgumentException("no null list allowed");
        }
        int alleleCount = first.numberOfAlleles();
        if (alleleCount != second.numberOfAlleles()) {
            return false;
        }
        for (int i = 0; i < alleleCount; ++i) {
            A firstSample = first.getAllele(i);
            Utils.nonNull(firstSample, "no null samples allowed in sample-lists: first list at " + i);
            A secondSample = second.getAllele(i);
            Utils.nonNull(secondSample, "no null samples allowed in sample-list: second list at " + i);
            if (firstSample.equals(secondSample)) continue;
            return false;
        }
        return true;
    }

    default public int indexOfReference() {
        int alleleCount = this.numberOfAlleles();
        for (int i = 0; i < alleleCount; ++i) {
            if (!this.getAllele(i).isReference()) continue;
            return i;
        }
        return -1;
    }

    default public List<A> asListOfAlleles() {
        return new AbstractList<A>(){

            @Override
            public A get(int index) {
                return AlleleList.this.getAllele(index);
            }

            @Override
            public int size() {
                return AlleleList.this.numberOfAlleles();
            }
        };
    }

    default public AlleleListPermutation<A> permutation(AlleleList<A> target) {
        if (AlleleList.equals(this, target)) {
            return new NonPermutation(this);
        }
        return new ActualPermutation(this, target);
    }

    public static final class ActualPermutation<A extends Allele>
    implements AlleleListPermutation<A> {
        private final AlleleList<A> from;
        private final AlleleList<A> to;
        private final int[] fromIndex;
        private final boolean[] keptFromIndices;
        private final boolean nonPermuted;
        private final boolean isPartial;

        private ActualPermutation(AlleleList<A> original, AlleleList<A> target) {
            this.from = original;
            this.to = target;
            this.keptFromIndices = new boolean[original.numberOfAlleles()];
            int toSize = target.numberOfAlleles();
            int fromSize = original.numberOfAlleles();
            if (fromSize < toSize) {
                throw new IllegalArgumentException("target allele list is not a permutation of the original allele list");
            }
            this.fromIndex = new int[toSize];
            boolean nonPermuted = fromSize == toSize;
            this.isPartial = !nonPermuted;
            for (int i = 0; i < toSize; ++i) {
                int originalIndex = original.indexOfAllele(target.getAllele(i));
                if (originalIndex < 0) {
                    throw new IllegalArgumentException("target allele list is not a permutation of the original allele list");
                }
                this.keptFromIndices[originalIndex] = true;
                this.fromIndex[i] = originalIndex;
                nonPermuted &= originalIndex == i;
            }
            this.nonPermuted = nonPermuted;
        }

        @Override
        public boolean isPartial() {
            return this.isPartial;
        }

        @Override
        public boolean isNonPermuted() {
            return this.nonPermuted;
        }

        @Override
        public int toIndex(int fromIndex) {
            return this.to.indexOfAllele(this.from.getAllele(fromIndex));
        }

        @Override
        public int fromIndex(int toIndex) {
            return this.fromIndex[toIndex];
        }

        @Override
        public boolean isKept(int fromIndex) {
            return this.keptFromIndices[fromIndex];
        }

        @Override
        public int fromSize() {
            return this.from.numberOfAlleles();
        }

        @Override
        public int toSize() {
            return this.to.numberOfAlleles();
        }

        @Override
        public List<A> fromList() {
            return this.from.asListOfAlleles();
        }

        @Override
        public List<A> toList() {
            return this.to.asListOfAlleles();
        }

        @Override
        public int numberOfAlleles() {
            return this.to.numberOfAlleles();
        }

        @Override
        public int indexOfAllele(A allele) {
            return this.to.indexOfAllele(allele);
        }

        @Override
        public A getAllele(int index) {
            return this.to.getAllele(index);
        }
    }

    public static final class NonPermutation<A extends Allele>
    implements AlleleListPermutation<A> {
        private final AlleleList<A> list;

        public NonPermutation(AlleleList<A> original) {
            this.list = original;
        }

        @Override
        public boolean isPartial() {
            return false;
        }

        @Override
        public boolean isNonPermuted() {
            return true;
        }

        @Override
        public int toIndex(int fromIndex) {
            return fromIndex;
        }

        @Override
        public int fromIndex(int toIndex) {
            return toIndex;
        }

        @Override
        public boolean isKept(int fromIndex) {
            return true;
        }

        @Override
        public int fromSize() {
            return this.list.numberOfAlleles();
        }

        @Override
        public int toSize() {
            return this.list.numberOfAlleles();
        }

        @Override
        public List<A> fromList() {
            return this.list.asListOfAlleles();
        }

        @Override
        public List<A> toList() {
            return this.list.asListOfAlleles();
        }

        @Override
        public int numberOfAlleles() {
            return this.list.numberOfAlleles();
        }

        @Override
        public int indexOfAllele(A allele) {
            return this.list.indexOfAllele(allele);
        }

        @Override
        public A getAllele(int index) {
            return this.list.getAllele(index);
        }
    }
}

