/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.genotyper;

import htsjdk.variant.variantcontext.Allele;
import java.util.List;
import org.apache.commons.math3.util.MathArrays;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeAlleleCounts;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeCalculationArgumentCollection;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeLikelihoodCalculator;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Nucleotide;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.dragstr.DragstrParams;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public final class GenotypePriorCalculator {
    private static final int NUMBER_OF_ALLELE_TYPES = AlleleType.values().length;
    private static final double LOG10_SNP_NORMALIZATION_CONSTANT = MathUtils.log10(Nucleotide.STANDARD_BASES.size() - 1);
    private final double[] hetValues = new double[NUMBER_OF_ALLELE_TYPES];
    private final double[] homValues = new double[NUMBER_OF_ALLELE_TYPES];
    private final double[] diffValues;

    private GenotypePriorCalculator(double snpHet, double snpHom, double indelHet, double indelHom, double otherHet, double otherHom) {
        this.hetValues[AlleleType.SNP.ordinal()] = snpHet - LOG10_SNP_NORMALIZATION_CONSTANT;
        this.homValues[AlleleType.SNP.ordinal()] = snpHom - LOG10_SNP_NORMALIZATION_CONSTANT;
        this.hetValues[AlleleType.INDEL.ordinal()] = indelHet;
        this.homValues[AlleleType.INDEL.ordinal()] = indelHom;
        this.hetValues[AlleleType.OTHER.ordinal()] = otherHet;
        this.homValues[AlleleType.OTHER.ordinal()] = otherHom;
        this.diffValues = MathArrays.ebeSubtract((double[])this.homValues, (double[])this.hetValues);
    }

    public static GenotypePriorCalculator givenHetToHomRatio(double log10SnpHet, double log10IndelHet, double log10OtherHet, double hetHomRatio) {
        double log10Ratio = Math.log10(hetHomRatio);
        return new GenotypePriorCalculator(log10SnpHet, log10SnpHet - log10Ratio, log10IndelHet, log10IndelHet - log10Ratio, log10OtherHet, log10OtherHet - log10Ratio);
    }

    public static GenotypePriorCalculator givenDragstrParams(DragstrParams dragstrParams, int period, int repeats, double snpHeterozygosity, double hetHomRatio) {
        double indelHet = -0.1 * dragstrParams.api(period, repeats);
        double otherHet = Math.max(snpHeterozygosity, indelHet);
        return GenotypePriorCalculator.givenHetToHomRatio(snpHeterozygosity, indelHet, otherHet, hetHomRatio);
    }

    public static GenotypePriorCalculator assumingHW(double snpHet, double indelHet) {
        ParamUtils.isNegativeOrZero(snpHet, "snp-het in log10 scale must be 0 or a negative");
        ParamUtils.isNegativeOrZero(snpHet, "indel-het in log10 scale must be 0 or a negative");
        return GenotypePriorCalculator.assumingHW(snpHet, indelHet, Math.max(snpHet, indelHet));
    }

    private static GenotypePriorCalculator assumingHW(double snpHet, double indelHet, double otherHet) {
        return new GenotypePriorCalculator(snpHet, snpHet * 2.0, indelHet, indelHet * 2.0, otherHet, otherHet * 2.0);
    }

    public static GenotypePriorCalculator assumingHW(GenotypeCalculationArgumentCollection genotypeArgs) {
        return GenotypePriorCalculator.assumingHW(Math.log10(genotypeArgs.snpHeterozygosity), Math.log10(genotypeArgs.indelHeterozygosity));
    }

    public double[] getLog10Priors(GenotypeLikelihoodCalculator lkCalculator, List<Allele> alleles) {
        Utils.nonNull(lkCalculator);
        Utils.nonNull(alleles);
        if (lkCalculator.alleleCount() < alleles.size()) {
            throw new IllegalArgumentException("the number of alleles in the input calculator must be at least as large as the number of alleles in the input list");
        }
        int[] alleleTypes = this.calculateAlleleTypes(alleles);
        int numberOfGenotypes = lkCalculator.genotypeCount();
        double[] result = new double[numberOfGenotypes];
        for (int g = 1; g < numberOfGenotypes; ++g) {
            GenotypeAlleleCounts gac = lkCalculator.genotypeAlleleCountsAt(g);
            result[g] = gac.sumOverAlleleIndicesAndCounts((idx, cnt) -> cnt == 2 ? this.homValues[alleleTypes[idx]] : this.hetValues[alleleTypes[idx]] + this.diffValues[alleleTypes[idx]] * (double)(cnt - 1));
        }
        return result;
    }

    private int[] calculateAlleleTypes(List<Allele> alleles) {
        Utils.validateArg(!alleles.isEmpty(), "the input allele list cannot empty");
        Allele refAllele = alleles.get(0);
        Utils.nonNull(refAllele, "the reference allele cannot be null");
        Utils.validateArg(refAllele.isReference(), "the first allele must be a valid reference");
        int referenceLength = refAllele.length();
        return alleles.stream().map(allele -> {
            if (allele.isReference()) {
                return AlleleType.REF;
            }
            if (allele.isCalled() && !allele.isSymbolic()) {
                return allele.length() == referenceLength ? AlleleType.SNP : AlleleType.INDEL;
            }
            if (allele.equals((Object)Allele.SV_SIMPLE_INS) || allele.equals((Object)Allele.SV_SIMPLE_DEL)) {
                throw new IllegalArgumentException("cannot handle symbolic indels: " + allele);
            }
            return AlleleType.OTHER;
        }).mapToInt(Enum::ordinal).toArray();
    }

    private static enum AlleleType {
        REF,
        SNP,
        INDEL,
        OTHER;

    }
}

