/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.genotyper;

import htsjdk.variant.variantcontext.Allele;
import java.util.Collection;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.collections.IndexedSet;
import org.broadinstitute.hellbender.utils.genotyper.AlleleList;

public final class IndexedAlleleList<A extends Allele>
implements AlleleList<A> {
    private final IndexedSet<A> alleles;

    public IndexedAlleleList() {
        this.alleles = new IndexedSet<Allele>(new Allele[0]);
    }

    @SafeVarargs
    public IndexedAlleleList(A ... alleles) {
        this.alleles = new IndexedSet<A>(alleles);
    }

    public IndexedAlleleList(Collection<A> alleles) {
        this.alleles = new IndexedSet<A>(alleles);
    }

    @Override
    public int numberOfAlleles() {
        return this.alleles.size();
    }

    @Override
    public int indexOfAllele(A allele) {
        Utils.nonNull(allele);
        return this.alleles.indexOf(allele);
    }

    @Override
    public A getAllele(int index) {
        Utils.validIndex(index, this.alleles.size());
        return (A)((Allele)this.alleles.get(index));
    }
}

