/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.genotyper;

import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.broadinstitute.hellbender.utils.Utils;

public interface SampleList {
    public static final SampleList EMPTY_LIST = new SampleList(){

        @Override
        public int numberOfSamples() {
            return 0;
        }

        @Override
        public int indexOfSample(String sample) {
            Utils.nonNull(sample);
            return -1;
        }

        @Override
        public String getSample(int sampleIndex) {
            throw new IllegalArgumentException("index is out of valid range");
        }
    };

    public static SampleList emptySampleList() {
        return EMPTY_LIST;
    }

    public int numberOfSamples();

    public int indexOfSample(String var1);

    public String getSample(int var1);

    public static boolean equals(SampleList first, SampleList second) {
        Utils.nonNull(first, "first list is null");
        Utils.nonNull(second, "second list is null");
        int sampleCount = first.numberOfSamples();
        if (sampleCount != second.numberOfSamples()) {
            return false;
        }
        for (int i = 0; i < sampleCount; ++i) {
            String secondSample;
            String firstSample = first.getSample(i);
            if (firstSample.equals(secondSample = second.getSample(i))) continue;
            return false;
        }
        return true;
    }

    default public List<String> asListOfSamples() {
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return SampleList.this.getSample(index);
            }

            @Override
            public int size() {
                return SampleList.this.numberOfSamples();
            }
        };
    }

    default public Set<String> asSetOfSamples() {
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < SampleList.this.numberOfSamples();
                    }

                    @Override
                    public String next() {
                        if (this.index >= SampleList.this.numberOfSamples()) {
                            throw new NoSuchElementException("iterating beyond sample list end");
                        }
                        return SampleList.this.getSample(this.index++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("unsupported operation exception");
                    }
                };
            }

            @Override
            public int size() {
                return SampleList.this.numberOfSamples();
            }

            @Override
            public boolean contains(Object obj) {
                return obj instanceof String && SampleList.this.indexOfSample((String)obj) >= 0;
            }
        };
    }

    public static SampleList singletonSampleList(final String sampleName) {
        Utils.nonNull(sampleName, "the sample name cannot be null");
        return new SampleList(){

            @Override
            public int numberOfSamples() {
                return 1;
            }

            @Override
            public int indexOfSample(String sample) {
                return sampleName.equals(sample) ? 0 : -1;
            }

            @Override
            public String getSample(int sampleIndex) {
                if (sampleIndex == 0) {
                    return sampleName;
                }
                throw new IllegalArgumentException("index is out of bounds");
            }
        };
    }
}

