/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.haplotype;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public final class EventMap
extends TreeMap<Integer, VariantContext> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(EventMap.class);
    protected static final int MIN_NUMBER_OF_EVENTS_TO_COMBINE_INTO_BLOCK_SUBSTITUTION = 3;
    private static final int MAX_EVENTS_PER_HAPLOTYPE = 3;
    private static final int MAX_INDELS_PER_HAPLOTYPE = 2;
    public static final Allele SYMBOLIC_UNASSEMBLED_EVENT_ALLELE = Allele.create((String)"<UNASSEMBLED_EVENT>", (boolean)false);
    private final Haplotype haplotype;
    private final byte[] ref;
    private final Locatable refLoc;
    private final String sourceNameToAdd;

    public EventMap(Haplotype haplotype, byte[] ref, Locatable refLoc, String sourceNameToAdd, int maxMnpDistance) {
        this.haplotype = haplotype;
        this.ref = ref;
        this.refLoc = refLoc;
        this.sourceNameToAdd = sourceNameToAdd;
        this.processCigarForInitialEvents(maxMnpDistance);
    }

    public EventMap(Collection<VariantContext> stateForTesting) {
        this.haplotype = null;
        this.ref = null;
        this.refLoc = null;
        this.sourceNameToAdd = null;
        for (VariantContext vc : stateForTesting) {
            this.addVC(vc);
        }
    }

    protected void processCigarForInitialEvents(int maxMnpDistance) {
        ParamUtils.isPositiveOrZero(maxMnpDistance, "maxMnpDistance may not be negative.");
        Cigar cigar = this.haplotype.getCigar();
        byte[] alignment = this.haplotype.getBases();
        int refPos = this.haplotype.getAlignmentStartHapwrtRef();
        if (refPos < 0) {
            return;
        }
        ArrayList<VariantContext> proposedEvents = new ArrayList<VariantContext>();
        int alignmentPos = 0;
        block6: for (int cigarIndex = 0; cigarIndex < cigar.numCigarElements(); ++cigarIndex) {
            CigarElement ce = cigar.getCigarElement(cigarIndex);
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case I: {
                    byte refByte;
                    if (refPos > 0) {
                        ArrayList<Allele> insertionAlleles = new ArrayList<Allele>();
                        int insertionStart = this.refLoc.getStart() + refPos - 1;
                        refByte = this.ref[refPos - 1];
                        if (BaseUtils.isRegularBase(refByte)) {
                            insertionAlleles.add(Allele.create((byte)refByte, (boolean)true));
                        }
                        if (cigarIndex != 0 && cigarIndex != cigar.numCigarElements() - 1) {
                            byte[] insertionBases = new byte[]{};
                            insertionBases = ArrayUtils.add((byte[])insertionBases, (byte)this.ref[refPos - 1]);
                            if (BaseUtils.isAllRegularBases(insertionBases = ArrayUtils.addAll((byte[])insertionBases, (byte[])Arrays.copyOfRange(alignment, alignmentPos, alignmentPos + elementLength)))) {
                                insertionAlleles.add(Allele.create((byte[])insertionBases, (boolean)false));
                            }
                        }
                        if (insertionAlleles.size() == 2) {
                            proposedEvents.add(new VariantContextBuilder(this.sourceNameToAdd, this.refLoc.getContig(), (long)insertionStart, (long)insertionStart, insertionAlleles).make());
                        }
                    }
                    alignmentPos += elementLength;
                    continue block6;
                }
                case S: {
                    alignmentPos += elementLength;
                    continue block6;
                }
                case D: {
                    if (refPos > 0) {
                        byte[] deletionBases = Arrays.copyOfRange(this.ref, refPos - 1, refPos + elementLength);
                        ArrayList<Allele> deletionAlleles = new ArrayList<Allele>();
                        int deletionStart = this.refLoc.getStart() + refPos - 1;
                        byte refByte = this.ref[refPos - 1];
                        if (BaseUtils.isRegularBase(refByte) && BaseUtils.isAllRegularBases(deletionBases)) {
                            deletionAlleles.add(Allele.create((byte[])deletionBases, (boolean)true));
                            deletionAlleles.add(Allele.create((byte)refByte, (boolean)false));
                            proposedEvents.add(new VariantContextBuilder(this.sourceNameToAdd, this.refLoc.getContig(), (long)deletionStart, (long)(deletionStart + elementLength), deletionAlleles).make());
                        }
                    }
                    refPos += elementLength;
                    continue block6;
                }
                case M: 
                case EQ: 
                case X: {
                    byte refByte;
                    ArrayDeque<Integer> mismatchOffsets = new ArrayDeque<Integer>();
                    for (int offset = 0; offset < elementLength; ++offset) {
                        boolean mismatch;
                        refByte = this.ref[refPos + offset];
                        byte altByte = alignment[alignmentPos + offset];
                        boolean bl = mismatch = refByte != altByte && BaseUtils.isRegularBase(refByte) && BaseUtils.isRegularBase(altByte);
                        if (!mismatch) continue;
                        mismatchOffsets.add(offset);
                    }
                    while (!mismatchOffsets.isEmpty()) {
                        int start;
                        int end = start = ((Integer)mismatchOffsets.poll()).intValue();
                        while (!mismatchOffsets.isEmpty() && (Integer)mismatchOffsets.peek() - end <= maxMnpDistance) {
                            end = (Integer)mismatchOffsets.poll();
                        }
                        Allele refAllele = Allele.create((byte[])Arrays.copyOfRange(this.ref, refPos + start, refPos + end + 1), (boolean)true);
                        Allele altAllele = Allele.create((byte[])Arrays.copyOfRange(alignment, alignmentPos + start, alignmentPos + end + 1), (boolean)false);
                        proposedEvents.add(new VariantContextBuilder(this.sourceNameToAdd, this.refLoc.getContig(), (long)(this.refLoc.getStart() + refPos + start), (long)(this.refLoc.getStart() + refPos + end), Arrays.asList(refAllele, altAllele)).make());
                    }
                    refPos += elementLength;
                    alignmentPos += elementLength;
                    continue block6;
                }
                default: {
                    throw new GATKException("Unsupported cigar operator created during SW alignment: " + ce.getOperator());
                }
            }
        }
        for (VariantContext proposedEvent : proposedEvents) {
            this.addVC(proposedEvent, true);
        }
    }

    public void addVC(VariantContext vc) {
        this.addVC(vc, true);
    }

    public void addVC(VariantContext vc, boolean merge) {
        Utils.nonNull(vc);
        if (this.containsKey(vc.getStart())) {
            Utils.validate(merge, () -> "Will not merge previously bound variant contexts as merge is false at " + vc);
            VariantContext prev = (VariantContext)this.get(vc.getStart());
            this.put(vc.getStart(), this.makeBlock(prev, vc));
        } else {
            this.put(vc.getStart(), vc);
        }
    }

    protected VariantContext makeBlock(VariantContext vc1, VariantContext vc2) {
        Allele alt;
        Allele ref;
        Utils.validateArg(vc1.getStart() == vc2.getStart(), () -> "vc1 and 2 must have the same start but got " + vc1 + " and " + vc2);
        Utils.validateArg(vc1.isBiallelic(), "vc1 must be biallelic");
        if (!vc1.isSNP()) {
            Utils.validateArg(vc1.isSimpleDeletion() && vc2.isSimpleInsertion() || vc1.isSimpleInsertion() && vc2.isSimpleDeletion(), () -> "Can only merge single insertion with deletion (or vice versa) but got " + vc1 + " merging with " + vc2);
        } else {
            Utils.validateArg(!vc2.isSNP(), () -> "vc1 is " + vc1 + " but vc2 is a SNP, which implies there's been some terrible bug in the cigar " + vc2);
        }
        VariantContextBuilder b = new VariantContextBuilder(vc1);
        if (vc1.isSNP()) {
            if (vc1.getReference().equals((Object)vc2.getReference())) {
                ref = vc1.getReference();
                alt = Allele.create((String)(vc1.getAlternateAllele(0).getDisplayString() + vc2.getAlternateAllele(0).getDisplayString().substring(1)), (boolean)false);
            } else {
                ref = vc2.getReference();
                alt = vc1.getAlternateAllele(0);
                b.stop((long)vc2.getEnd());
            }
        } else {
            VariantContext insertion = vc1.isSimpleInsertion() ? vc1 : vc2;
            VariantContext deletion = vc1.isSimpleInsertion() ? vc2 : vc1;
            ref = deletion.getReference();
            alt = insertion.getAlternateAllele(0);
            b.stop((long)deletion.getEnd());
        }
        return b.alleles(Arrays.asList(ref, alt)).make();
    }

    public Set<Integer> getStartPositions() {
        return this.keySet();
    }

    public Collection<VariantContext> getVariantContexts() {
        return this.values();
    }

    public int getNumberOfEvents() {
        return this.size();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("EventMap{");
        for (VariantContext vc : this.getVariantContexts()) {
            b.append(String.format("%s:%d-%d %s,", vc.getContig(), vc.getStart(), vc.getEnd(), vc.getAlleles()));
        }
        b.append("}");
        return b.toString();
    }

    public static TreeSet<Integer> buildEventMapsForHaplotypes(List<Haplotype> haplotypes, byte[] ref, Locatable refLoc, boolean debug, int maxMnpDistance) {
        ParamUtils.isPositiveOrZero(maxMnpDistance, "maxMnpDistance may not be negative.");
        TreeSet<Integer> startPosKeySet = new TreeSet<Integer>();
        int hapNumber = 0;
        if (debug) {
            logger.info("=== Best Haplotypes ===");
        }
        for (Haplotype h : haplotypes) {
            h.setEventMap(new EventMap(h, ref, refLoc, "HC" + hapNumber++, maxMnpDistance));
            startPosKeySet.addAll(h.getEventMap().getStartPositions());
            h.getEventMap().getVariantContexts().forEach((? super T vc) -> Utils.validate(vc.getAlleles().size() == 2, () -> "Error Haplotype event map Variant Context has too many alleles " + vc.getAlleles() + " for hapllotype: " + (Object)((Object)h)));
            if (!debug) continue;
            logger.info(h.toString());
            logger.info("> Cigar = " + h.getCigar());
            logger.info(">> Events = " + h.getEventMap());
        }
        return startPosKeySet;
    }

    public List<VariantContext> getOverlappingEvents(int loc) {
        List<VariantContext> overlappingEvents = this.headMap(loc, true).values().stream().filter(v -> v.getEnd() >= loc).collect(Collectors.toList());
        List deletionEventsEndingAtLoc = overlappingEvents.stream().filter(v -> v.isSimpleDeletion() && v.getEnd() == loc).collect(Collectors.toList());
        boolean containsDeletionEndingAtLoc = deletionEventsEndingAtLoc.size() > 0;
        boolean containsInsertionAtLoc = overlappingEvents.stream().anyMatch(VariantContext::isSimpleInsertion);
        if (containsDeletionEndingAtLoc && containsInsertionAtLoc) {
            overlappingEvents.remove(deletionEventsEndingAtLoc.get(0));
        }
        return overlappingEvents;
    }
}

