/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.haplotype;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.Allele;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.haplotype.EventMap;
import org.broadinstitute.hellbender.utils.read.AlignmentUtils;
import org.broadinstitute.hellbender.utils.read.CigarBuilder;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public final class Haplotype
extends Allele {
    private static final long serialVersionUID = 1L;
    public static final Comparator<Haplotype> SIZE_AND_BASE_ORDER = Comparator.comparingInt(hap -> hap.getBases().length).thenComparing(hap -> hap.getBaseString());
    private Locatable genomeLocation = null;
    private EventMap eventMap = null;
    private Cigar cigar;
    private int alignmentStartHapwrtRef;
    private double score = Double.NaN;
    private int kmerSize = 0;

    public Haplotype(byte[] bases, boolean isRef) {
        super(Arrays.copyOf(bases, bases.length), isRef);
    }

    public Haplotype(byte[] bases) {
        this(bases, false);
    }

    public Haplotype(byte[] bases, boolean isRef, int alignmentStartHapwrtRef, Cigar cigar) {
        this(bases, isRef);
        this.alignmentStartHapwrtRef = alignmentStartHapwrtRef;
        this.setCigar(cigar);
    }

    public Haplotype(byte[] bases, Locatable loc) {
        this(bases, false);
        this.genomeLocation = loc;
    }

    public Haplotype trim(Locatable loc) {
        Utils.nonNull(loc, "Loc cannot be null");
        Utils.nonNull(this.genomeLocation, "Cannot trim a Haplotype without containing GenomeLoc");
        Utils.validateArg(new SimpleInterval(this.genomeLocation).contains(loc), () -> "Can only trim a Haplotype to a containing span.  My loc is " + this.genomeLocation + " but wanted trim to " + loc);
        Utils.nonNull(this.getCigar(), "Cannot trim haplotype without a cigar " + (Object)((Object)this));
        int newStart = loc.getStart() - this.genomeLocation.getStart();
        int newStop = newStart + loc.getEnd() - loc.getStart();
        byte[] newBases = AlignmentUtils.getBasesCoveringRefInterval(newStart, newStop, this.getBases(), 0, this.getCigar());
        if (newBases == null || newBases.length == 0) {
            return null;
        }
        Cigar newCigar = AlignmentUtils.trimCigarByReference(this.getCigar(), newStart, newStop).getCigar();
        boolean leadingInsertion = !newCigar.getFirstCigarElement().getOperator().consumesReferenceBases();
        boolean trailingInsertion = !newCigar.getLastCigarElement().getOperator().consumesReferenceBases();
        int firstIndexToKeepInclusive = leadingInsertion ? 1 : 0;
        int lastIndexToKeepExclusive = newCigar.numCigarElements() - (trailingInsertion ? 1 : 0);
        if (lastIndexToKeepExclusive <= firstIndexToKeepInclusive) {
            return null;
        }
        Cigar leadingIndelTrimmedNewCigar = !leadingInsertion && !trailingInsertion ? newCigar : new CigarBuilder(false).addAll(newCigar.getCigarElements().subList(firstIndexToKeepInclusive, lastIndexToKeepExclusive)).make();
        Haplotype ret = new Haplotype(newBases, this.isReference());
        ret.setCigar(leadingIndelTrimmedNewCigar);
        ret.setGenomeLocation(loc);
        ret.setScore(this.score);
        ret.setKmerSize(this.kmerSize);
        ret.setAlignmentStartHapwrtRef(newStart + this.getAlignmentStartHapwrtRef());
        return ret;
    }

    public boolean equals(Object h) {
        return h instanceof Haplotype && Arrays.equals(this.getBases(), ((Haplotype)((Object)h)).getBases());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBases());
    }

    public EventMap getEventMap() {
        return this.eventMap;
    }

    public void setEventMap(EventMap eventMap) {
        this.eventMap = eventMap;
    }

    public String toString() {
        return this.getDisplayString();
    }

    public Locatable getLocation() {
        return this.genomeLocation;
    }

    public void setGenomeLocation(Locatable genomeLocation) {
        this.genomeLocation = genomeLocation;
    }

    public long getStartPosition() {
        return this.genomeLocation.getStart();
    }

    public long getStopPosition() {
        return this.genomeLocation.getEnd();
    }

    public int getAlignmentStartHapwrtRef() {
        return this.alignmentStartHapwrtRef;
    }

    public void setAlignmentStartHapwrtRef(int alignmentStartHapwrtRef) {
        this.alignmentStartHapwrtRef = alignmentStartHapwrtRef;
    }

    public Cigar getCigar() {
        return this.cigar;
    }

    public Cigar getConsolidatedPaddedCigar(int padSize) {
        Utils.validateArg(padSize >= 0, () -> "padSize must be >= 0 but got " + padSize);
        return new CigarBuilder().addAll((Iterable<CigarElement>)this.getCigar()).add(new CigarElement(padSize, CigarOperator.M)).make();
    }

    public void setCigar(Cigar cigar) {
        this.cigar = new CigarBuilder(false).addAll((Iterable<CigarElement>)cigar).make();
        Utils.validateArg(this.cigar.getReadLength() == this.length(), () -> "Read length " + this.length() + " not equal to the read length of the cigar " + cigar.getReadLength() + " " + this.cigar);
    }

    public Haplotype insertAllele(Allele refAllele, Allele altAllele, int refInsertLocation, int genomicInsertLocation) {
        Pair<Integer, CigarOperator> haplotypeInsertLocationAndOperator = ReadUtils.getReadIndexForReferenceCoordinate(this.alignmentStartHapwrtRef, this.cigar, refInsertLocation);
        if ((Integer)haplotypeInsertLocationAndOperator.getLeft() == -1 || !((CigarOperator)haplotypeInsertLocationAndOperator.getRight()).consumesReadBases()) {
            return null;
        }
        int haplotypeInsertLocation = (Integer)haplotypeInsertLocationAndOperator.getLeft();
        byte[] myBases = this.getBases();
        if (haplotypeInsertLocation + refAllele.length() >= myBases.length) {
            return null;
        }
        byte[] newHaplotypeBases = new byte[]{};
        newHaplotypeBases = ArrayUtils.addAll((byte[])newHaplotypeBases, (byte[])ArrayUtils.subarray((byte[])myBases, (int)0, (int)haplotypeInsertLocation));
        newHaplotypeBases = ArrayUtils.addAll((byte[])newHaplotypeBases, (byte[])altAllele.getBases());
        newHaplotypeBases = ArrayUtils.addAll((byte[])newHaplotypeBases, (byte[])ArrayUtils.subarray((byte[])myBases, (int)(haplotypeInsertLocation + refAllele.length()), (int)myBases.length));
        return new Haplotype(newHaplotypeBases);
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public Locatable getGenomeLocation() {
        return this.genomeLocation;
    }

    public int getKmerSize() {
        return this.kmerSize;
    }

    public void setKmerSize(int kmerSize) {
        this.kmerSize = kmerSize;
    }
}

