/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.haplotype;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import java.util.ArrayList;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public abstract class HaplotypeBAMDestination {
    private final SAMFileHeader bamOutputHeader;
    private final String haplotypeReadGroupID;
    private static final String haplotypeSampleTag = "HC";

    protected HaplotypeBAMDestination(SAMFileHeader sourceHeader, String haplotypeReadGroupID) {
        Utils.nonNull(sourceHeader, "sourceHeader cannot be null");
        Utils.nonNull(haplotypeReadGroupID, "haplotypeReadGroupID cannot be null");
        this.haplotypeReadGroupID = haplotypeReadGroupID;
        this.bamOutputHeader = new SAMFileHeader();
        this.bamOutputHeader.setSequenceDictionary(sourceHeader.getSequenceDictionary());
        this.bamOutputHeader.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        ArrayList<SAMReadGroupRecord> readGroups = new ArrayList<SAMReadGroupRecord>();
        readGroups.addAll(sourceHeader.getReadGroups());
        SAMReadGroupRecord rgRec = new SAMReadGroupRecord(this.getHaplotypeReadGroupID());
        rgRec.setSample(haplotypeSampleTag);
        rgRec.setSequencingCenter("BI");
        readGroups.add(rgRec);
        this.bamOutputHeader.setReadGroups(readGroups);
        ArrayList<SAMProgramRecord> programRecords = new ArrayList<SAMProgramRecord>(sourceHeader.getProgramRecords());
        programRecords.add(new SAMProgramRecord("HaplotypeBAMWriter"));
        this.bamOutputHeader.setProgramRecords(programRecords);
    }

    public abstract void add(GATKRead var1);

    public String getHaplotypeReadGroupID() {
        return this.haplotypeReadGroupID;
    }

    public String getHaplotypeSampleTag() {
        return haplotypeSampleTag;
    }

    abstract void close();

    public SAMFileHeader getBAMOutputHeader() {
        return this.bamOutputHeader;
    }
}

