/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.haplotype;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFlag;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.Locatable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.AlleleLikelihoods;
import org.broadinstitute.hellbender.utils.haplotype.Haplotype;
import org.broadinstitute.hellbender.utils.haplotype.HaplotypeBAMDestination;
import org.broadinstitute.hellbender.utils.haplotype.SAMFileDestination;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.SAMRecordToGATKReadAdapter;

public class HaplotypeBAMWriter
implements AutoCloseable {
    private long uniqueNameCounter = 1L;
    public static final String DEFAULT_HAPLOTYPE_READ_GROUP_ID = "ArtificialHaplotypeRG";
    public static final String DEFAULT_GATK3_HAPLOTYPE_READ_GROUP_ID = "ArtificialHaplotype";
    private static final int bestHaplotypeMQ = 60;
    private static final int otherMQ = 0;
    private final HaplotypeBAMDestination output;
    private WriterType writerType;
    private boolean writeHaplotypes = true;

    public HaplotypeBAMWriter(WriterType type, Path outputPath, boolean createBamOutIndex, boolean createBamOutMD5, SAMFileHeader sourceHeader) {
        this(type, new SAMFileDestination(outputPath, createBamOutIndex, createBamOutMD5, sourceHeader, DEFAULT_HAPLOTYPE_READ_GROUP_ID));
    }

    public HaplotypeBAMWriter(WriterType type, HaplotypeBAMDestination destination) {
        Utils.nonNull(type, "type cannot be null");
        Utils.nonNull(destination, "destination cannot be null");
        this.writerType = type;
        this.output = destination;
    }

    @Override
    public void close() {
        this.output.close();
    }

    public void writeReadsAlignedToHaplotypes(Collection<Haplotype> haplotypes, Locatable paddedReferenceLoc, Collection<Haplotype> bestHaplotypes, Set<Haplotype> calledHaplotypes, AlleleLikelihoods<GATKRead, Haplotype> readLikelihoods, Locatable callableRegion) {
        Utils.nonNull(haplotypes, "haplotypes cannot be null");
        Utils.nonNull(paddedReferenceLoc, "paddedReferenceLoc cannot be null");
        Utils.nonNull(calledHaplotypes, "calledHaplotypes cannot be null");
        Utils.nonNull(readLikelihoods, "readLikelihoods cannot be null");
        Utils.nonNull(bestHaplotypes, "bestHaplotypes cannot be null");
        if (this.writerType.equals((Object)WriterType.CALLED_HAPLOTYPES)) {
            if (calledHaplotypes.isEmpty()) {
                return;
            }
            this.writeHaplotypesAsReads(calledHaplotypes, calledHaplotypes, paddedReferenceLoc, callableRegion);
        } else if (this.writerType.equals((Object)WriterType.ALL_POSSIBLE_HAPLOTYPES)) {
            this.writeHaplotypesAsReads(haplotypes, new LinkedHashSet<Haplotype>(bestHaplotypes), paddedReferenceLoc, callableRegion);
        }
        int sampleCount = readLikelihoods.numberOfSamples();
        for (int i = 0; i < sampleCount; ++i) {
            for (GATKRead read : readLikelihoods.sampleEvidence(i)) {
                this.writeReadAgainstHaplotype(read);
            }
        }
    }

    public void writeReadsAlignedToHaplotypes(Collection<Haplotype> haplotypes, Locatable paddedReferenceLoc, Collection<Haplotype> bestHaplotypes, Set<Haplotype> calledHaplotypes, AlleleLikelihoods<GATKRead, Haplotype> readLikelihoods) {
        this.writeReadsAlignedToHaplotypes(haplotypes, paddedReferenceLoc, bestHaplotypes, calledHaplotypes, readLikelihoods, null);
    }

    private void writeReadAgainstHaplotype(GATKRead read) {
        Utils.nonNull(read, "read cannot be null");
        this.output.add(read);
    }

    private void writeHaplotypesAsReads(Collection<Haplotype> haplotypes, Set<Haplotype> bestHaplotypes, Locatable paddedReferenceLoc, Locatable callableRegion) {
        Utils.nonNull(haplotypes, "haplotypes cannot be null");
        Utils.nonNull(bestHaplotypes, "bestHaplotypes cannot be null");
        Utils.nonNull(paddedReferenceLoc, "paddedReferenceLoc cannot be null");
        if (this.writeHaplotypes) {
            for (Haplotype haplotype : haplotypes) {
                this.writeHaplotype(haplotype, paddedReferenceLoc, bestHaplotypes.contains((Object)haplotype), callableRegion);
            }
        }
    }

    private void writeHaplotype(Haplotype haplotype, Locatable paddedRefLoc, boolean isAmongBestHaplotypes, Locatable callableRegion) {
        Utils.nonNull(haplotype, "haplotype cannot be null");
        Utils.nonNull(paddedRefLoc, "paddedRefLoc cannot be null");
        SAMRecord record = new SAMRecord(this.output.getBAMOutputHeader());
        record.setReadBases(haplotype.getBases());
        record.setAlignmentStart(paddedRefLoc.getStart() + haplotype.getAlignmentStartHapwrtRef());
        record.setBaseQualities(Utils.dupBytes((byte)33, haplotype.getBases().length));
        record.setCigar(haplotype.getCigar());
        record.setMappingQuality(isAmongBestHaplotypes ? 60 : 0);
        record.setReadName(this.output.getHaplotypeSampleTag() + this.uniqueNameCounter++);
        record.setAttribute(this.output.getHaplotypeSampleTag(), (Object)haplotype.hashCode());
        record.setReadUnmappedFlag(false);
        record.setReferenceIndex(this.output.getBAMOutputHeader().getSequenceIndex(paddedRefLoc.getContig()));
        record.setAttribute(SAMTag.RG.toString(), (Object)this.output.getHaplotypeReadGroupID());
        record.setFlags(SAMFlag.READ_REVERSE_STRAND.intValue());
        if (callableRegion != null) {
            record.setAttribute("CR", (Object)callableRegion.toString());
        }
        this.output.add(new SAMRecordToGATKReadAdapter(record));
    }

    public void setWriteHaplotypes(boolean writeHaplotypes) {
        this.writeHaplotypes = writeHaplotypes;
    }

    public static enum WriterType {
        ALL_POSSIBLE_HAPLOTYPES,
        CALLED_HAPLOTYPES,
        NO_HAPLOTYPES;

    }
}

