/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.haplotype;

import htsjdk.samtools.SAMFileHeader;
import java.nio.file.Path;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.haplotype.HaplotypeBAMDestination;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;
import org.broadinstitute.hellbender.utils.read.SAMFileGATKReadWriter;

public final class SAMFileDestination
extends HaplotypeBAMDestination {
    private final SAMFileGATKReadWriter samWriter;

    public SAMFileDestination(Path outPath, boolean createBamOutIndex, boolean createBamOutMD5, SAMFileHeader sourceHeader, String haplotypeReadGroupID) {
        super(sourceHeader, haplotypeReadGroupID);
        this.samWriter = new SAMFileGATKReadWriter(ReadUtils.createCommonSAMWriter(outPath, null, this.getBAMOutputHeader(), false, createBamOutIndex, createBamOutMD5));
    }

    @Override
    void close() {
        this.samWriter.close();
    }

    @Override
    public void add(GATKRead read) {
        Utils.nonNull(read, "read cannot be null");
        this.samWriter.addRead(read);
    }
}

