/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.help;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.DocWorkUnitHandler;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.barclay.help.GSONWorkUnit;
import org.broadinstitute.barclay.help.HelpDoclet;
import org.broadinstitute.hellbender.utils.help.GATKDocWorkUnit;
import org.broadinstitute.hellbender.utils.help.GATKGSONWorkUnit;
import org.broadinstitute.hellbender.utils.help.GATKHelpDocWorkUnitHandler;
import org.broadinstitute.hellbender.utils.help.HelpConstants;

public class GATKHelpDoclet
extends HelpDoclet {
    private static final String GATK_FREEMARKER_INDEX_TEMPLATE_NAME = "generic.index.template.html";
    private static final String WALKER_TYPE_MAP_ENTRY = "walkertype";

    public static boolean start(RootDoc rootDoc) throws IOException {
        return new GATKHelpDoclet().startProcessDocs(rootDoc);
    }

    public String getIndexTemplateName() {
        return GATK_FREEMARKER_INDEX_TEMPLATE_NAME;
    }

    protected DocWorkUnit createWorkUnit(DocumentedFeature documentedFeature, ClassDoc classDoc, Class<?> clazz) {
        return new GATKDocWorkUnit((DocWorkUnitHandler)new GATKHelpDocWorkUnitHandler(this), documentedFeature, classDoc, clazz);
    }

    protected GSONWorkUnit createGSONWorkUnit(DocWorkUnit workUnit, List<Map<String, String>> groupMaps, List<Map<String, String>> featureMaps) {
        GATKGSONWorkUnit gatkGSONWorkUnit = new GATKGSONWorkUnit();
        gatkGSONWorkUnit.setWalkerType((String)workUnit.getRootMap().get(WALKER_TYPE_MAP_ENTRY));
        return gatkGSONWorkUnit;
    }

    protected final Map<String, String> getGroupMap(DocWorkUnit docWorkUnit) {
        Map root = super.getGroupMap(docWorkUnit);
        root.put("supercat", HelpConstants.getSuperCategoryProperty(docWorkUnit.getGroupName()));
        return root;
    }
}

