/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.help;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.broadinstitute.barclay.help.DocException;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.DocWorkUnitHandler;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.barclay.help.HelpDoclet;
import org.broadinstitute.barclay.help.WDLDoclet;
import org.broadinstitute.hellbender.utils.help.GATKWDLWorkUnitHandler;
import org.broadinstitute.hellbender.utils.help.HelpConstants;

public class GATKWDLDoclet
extends WDLDoclet {
    private static final String GATK_FREEMARKER_INDEX_TEMPLATE_NAME = "wdlIndexTemplate.html.ftl";
    public static final String OPT_BUILD_DIR = "-build-dir";
    private String buildDir;

    public String getIndexFileExtension() {
        return "html";
    }

    public static int optionLength(String option) {
        if (option.equals(OPT_BUILD_DIR)) {
            return 2;
        }
        return WDLDoclet.optionLength((String)option);
    }

    protected boolean parseOption(String[] option) {
        if (option[0].equals(OPT_BUILD_DIR)) {
            this.buildDir = option[1];
            return true;
        }
        return super.parseOption(option);
    }

    public static boolean start(RootDoc rootDoc) throws IOException {
        return new GATKWDLDoclet().startProcessDocs(rootDoc);
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public String getIndexTemplateName() {
        return GATK_FREEMARKER_INDEX_TEMPLATE_NAME;
    }

    protected DocWorkUnit createWorkUnit(DocumentedFeature documentedFeature, ClassDoc classDoc, Class<?> clazz) {
        return this.includeInDocs(documentedFeature, classDoc, clazz) ? new DocWorkUnit((DocWorkUnitHandler)new GATKWDLWorkUnitHandler((HelpDoclet)this), documentedFeature, classDoc, clazz) : null;
    }

    protected void processWorkUnitTemplate(Configuration cfg, DocWorkUnit workUnit, List<Map<String, String>> indexByGroupMaps, List<Map<String, String>> featureMaps) {
        String defaultWDLOutputFileName = workUnit.getTargetFileName();
        String defaultJSONOutputFileName = workUnit.getJSONFileName();
        this.exportWorkUnitTemplate(cfg, workUnit, workUnit.getTemplateName(), new File(this.getDestinationDir(), defaultWDLOutputFileName));
        this.exportWorkUnitTemplate(cfg, workUnit, "wdlJSONTemplate.json.ftl", new File(this.getDestinationDir(), defaultJSONOutputFileName));
        this.exportWorkUnitTemplate(cfg, workUnit, "wdlToolTemplateAllArgs.wdl.ftl", new File(this.getDestinationDir(), String.format("%sAllArgs.%s", FilenameUtils.getBaseName((String)defaultWDLOutputFileName), FilenameUtils.getExtension((String)defaultWDLOutputFileName))));
        this.exportWorkUnitTemplate(cfg, workUnit, "wdlJSONTemplateAllArgs.json.ftl", new File(this.getDestinationDir(), String.format("%sAllArgsInputs.json", FilenameUtils.getBaseName((String)defaultWDLOutputFileName))));
        this.exportWorkUnitTemplate(cfg, workUnit, "wdlToolTemplateAllArgsTest.wdl.ftl", new File(this.getDestinationDir(), String.format("%sAllArgsTest.%s", FilenameUtils.getBaseName((String)defaultWDLOutputFileName), FilenameUtils.getExtension((String)defaultWDLOutputFileName))));
        this.exportWorkUnitTemplate(cfg, workUnit, "wdlJSONTemplateAllArgsTest.json.ftl", new File(this.getDestinationDir(), String.format("%sAllArgsTestInputs.json", FilenameUtils.getBaseName((String)defaultWDLOutputFileName))));
    }

    protected final void exportWorkUnitTemplate(Configuration cfg, DocWorkUnit workUnit, String wdlTemplateName, File wdlOutputPath) {
        try {
            Template wdlTemplate = cfg.getTemplate(wdlTemplateName);
            try (OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(wdlOutputPath));){
                wdlTemplate.process((Object)workUnit.getRootMap(), (Writer)out);
            }
        }
        catch (IOException e) {
            throw new DocException("IOException during documentation creation", (Throwable)e);
        }
        catch (TemplateException e) {
            throw new DocException("TemplateException during documentation creation", (Throwable)e);
        }
    }

    protected final Map<String, String> getGroupMap(DocWorkUnit docWorkUnit) {
        Map root = super.getGroupMap(docWorkUnit);
        root.put("supercat", HelpConstants.getSuperCategoryProperty(docWorkUnit.getGroupName()));
        return root;
    }
}

