/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.help;

import htsjdk.samtools.util.Iso8601Date;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentDefinition;
import org.broadinstitute.barclay.argparser.CommandLineArgumentParser;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.NamedArgumentDefinition;
import org.broadinstitute.barclay.argparser.PositionalArguments;
import org.broadinstitute.barclay.argparser.SpecialArgumentsCollection;
import org.broadinstitute.barclay.argparser.WorkflowOutput;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.HelpDoclet;
import org.broadinstitute.barclay.help.WDLWorkUnitHandler;
import org.broadinstitute.hellbender.engine.FeatureInput;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.help.GATKWDLDoclet;
import picard.cmdline.CommandLineProgram;
import picard.illumina.parser.ReadStructure;

public class GATKWDLWorkUnitHandler
extends WDLWorkUnitHandler {
    private static final String GATK_FREEMARKER_TEMPLATE_NAME = "wdlToolTemplate.wdl.ftl";
    private static final String dummyWDLTestFileName = "dummyWDLTestFile";
    private static final String WDL_TEST_VALUE_PROPERTY = "testValue";
    private static final Map<Class<?>, ImmutablePair<String, String>> javaToWDLTypeMap = new HashMap<Class<?>, ImmutablePair<String, String>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(GATKPath.class, new ImmutablePair((Object)GATKPath.class.getSimpleName(), (Object)"File"));
            this.put(FeatureInput.class, new ImmutablePair((Object)FeatureInput.class.getSimpleName(), (Object)"File"));
            this.put(Iso8601Date.class, new ImmutablePair((Object)Iso8601Date.class.getSimpleName(), (Object)"String"));
            this.put(Date.class, new ImmutablePair((Object)Date.class.getSimpleName(), (Object)"String"));
            this.put(ReadStructure.class, new ImmutablePair((Object)ReadStructure.class.getSimpleName(), (Object)"String"));
        }
    };

    public GATKWDLWorkUnitHandler(HelpDoclet doclet) {
        super(doclet);
    }

    public String getTemplateName(DocWorkUnit workUnit) {
        return GATK_FREEMARKER_TEMPLATE_NAME;
    }

    public String getDestinationFilename(DocWorkUnit workUnit) {
        return workUnit.getClazz().getSimpleName() + ".wdl";
    }

    public String getJSONFilename(DocWorkUnit workUnit) {
        return workUnit.getClazz().getSimpleName() + "Inputs.json";
    }

    protected void processNamedArgument(DocWorkUnit currentWorkUnit, Map<String, List<Map<String, Object>>> args, NamedArgumentDefinition argDef) {
        if (!argDef.getUnderlyingField().getDeclaringClass().equals(SpecialArgumentsCollection.class)) {
            super.processNamedArgument(currentWorkUnit, args, argDef);
            List<Map<String, Object>> argMapList = args.get("all");
            argMapList.stream().forEach(m -> {
                String actualArgName = (String)m.get("actualArgName");
                if (actualArgName != null && actualArgName.equals("--" + argDef.getLongName())) {
                    String newSummary = ((String)m.get("summary")).replaceAll("[\"'\n]", "");
                    m.put("summary", newSummary);
                }
            });
        }
    }

    protected String processNamedArgument(Map<String, Object> argBindings, NamedArgumentDefinition argDef, String fieldCommentText) {
        String argCategory = super.processNamedArgument(argBindings, argDef, fieldCommentText);
        argBindings.put(WDL_TEST_VALUE_PROPERTY, this.testValueAsJSON(argDef.getLongName(), (ArgumentDefinition)argDef, (String)argBindings.get("type"), (String)argBindings.get("defaultValue")));
        return argCategory;
    }

    protected void processPositionalArguments(CommandLineArgumentParser clp, Map<String, List<Map<String, Object>>> args) {
        super.processPositionalArguments(clp, args);
        List<Map<String, Object>> positionalArgsList = args.get("positional");
        if (positionalArgsList != null && !positionalArgsList.isEmpty()) {
            Map<String, Object> positionalArgs = args.get("positional").get(0);
            positionalArgs.put(WDL_TEST_VALUE_PROPERTY, this.testValueAsJSON("--positionalArgs", (ArgumentDefinition)clp.getPositionalArgumentDefinition(), (String)positionalArgs.get("type"), (String)positionalArgs.get("defaultValue")));
        }
    }

    protected String testValueAsJSON(String longName, ArgumentDefinition argDef, String wdlType, String defaultWDLValue) {
        Argument argumentAnnotation = argDef.getUnderlyingField().getAnnotation(Argument.class);
        PositionalArguments positionalAnnotation = argDef.getUnderlyingField().getAnnotation(PositionalArguments.class);
        boolean isRequired = argumentAnnotation != null && !argumentAnnotation.optional() || positionalAnnotation != null;
        String dummyWDLTestFile = ((GATKWDLDoclet)this.getDoclet()).getBuildDir() + "/" + dummyWDLTestFileName;
        if (longName.equals("output-shard-tmp-dir")) {
            return "null";
        }
        if (wdlType.equals("File")) {
            if (isRequired) {
                return "\"" + dummyWDLTestFile + "\"";
            }
            return "null";
        }
        if (wdlType.equals("Array[File]")) {
            return String.format("[\"%s\", \"%s\"]", dummyWDLTestFile, dummyWDLTestFile);
        }
        if (defaultWDLValue.equals("null") || defaultWDLValue.equals("\"\"") || defaultWDLValue.equals("[]")) {
            if (isRequired) {
                if (wdlType.startsWith("Array")) {
                    return String.format("[\"%s\", \"%s\"]", this.getDefaultValueForType(argDef), this.getDefaultValueForType(argDef));
                }
                return "\"" + this.getDefaultValueForType(argDef) + "\"";
            }
            return "null";
        }
        if (defaultWDLValue.startsWith("[")) {
            if (isRequired) {
                return defaultWDLValue;
            }
            return "null";
        }
        if (wdlType.equals("Float") && (defaultWDLValue.equals("Infinity") || defaultWDLValue.equals("Nan"))) {
            return "\"" + defaultWDLValue + "\"";
        }
        return defaultWDLValue;
    }

    protected String getDefaultValueForType(ArgumentDefinition argDef) {
        Class clazz = argDef.getUnderlyingFieldClass();
        if (clazz.isEnum()) {
            return argDef.getUnderlyingFieldClass().getEnumConstants()[0].toString();
        }
        Object fieldDefaultValue = argDef.getArgumentValue();
        if (fieldDefaultValue != null && !fieldDefaultValue.toString().equals("[]")) {
            return fieldDefaultValue.toString();
        }
        if (clazz.isAssignableFrom(Boolean.class) || clazz.isAssignableFrom(Boolean.TYPE)) {
            return "true";
        }
        if (clazz.isAssignableFrom(Float.class) || clazz.isAssignableFrom(Float.TYPE) || clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Double.TYPE)) {
            return "0.0";
        }
        if (clazz.isAssignableFrom(Integer.class) || clazz.isAssignableFrom(Integer.TYPE) || clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Long.TYPE)) {
            return "1";
        }
        return "syntheticTestValue";
    }

    protected String convertJavaTypeToWDLType(WorkflowOutput workflowOutput, Class<?> argumentClass, String docType, String sourceContext) {
        if (FeatureInput.class.isAssignableFrom(argumentClass)) {
            if (!docType.contains(FeatureInput.class.getSimpleName())) {
                throw new GATKException(String.format("Don't know how to convert Java type %s in %s to a corresponding WDL type. The WDL generator type converter code must be updated to support this Java type.", argumentClass, sourceContext));
            }
            Pair<String, String> typeConversionPair = this.transformToWDLType(argumentClass);
            String convertedWDLType = docType.replaceFirst("FeatureInput\\[[a-zA-Z0-9?]+\\]", (String)typeConversionPair.getValue());
            return this.transformWorkflowOutputTypeToInputType(workflowOutput, convertedWDLType);
        }
        return super.convertJavaTypeToWDLType(workflowOutput, argumentClass, docType, sourceContext);
    }

    protected Pair<String, String> transformToWDLType(Class<?> argumentClass) {
        Pair conversion = (Pair)javaToWDLTypeMap.get(argumentClass);
        return conversion == null ? super.transformToWDLType(argumentClass) : conversion;
    }

    protected Pair<String, String> transformToWDLCollectionType(Class<?> argumentCollectionClass) {
        return argumentCollectionClass.equals(Collection.class) ? new ImmutablePair((Object)"Collection", (Object)"Array") : super.transformToWDLCollectionType(argumentCollectionClass);
    }

    protected void addCustomBindings(DocWorkUnit currentWorkUnit) {
        super.addCustomBindings(currentWorkUnit);
        Class toolClass = currentWorkUnit.getClazz();
        if (CommandLineProgram.class.isAssignableFrom(toolClass)) {
            CommandLineProgramProperties clpProperties = currentWorkUnit.getCommandLineProperties();
            currentWorkUnit.setProperty("picardsummary", (Object)clpProperties.summary());
        }
        currentWorkUnit.setProperty("buildDir", (Object)((GATKWDLDoclet)this.getDoclet()).getBuildDir());
    }
}

