/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.help;

import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.hellbender.utils.Utils;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.cmdline.programgroups.IntervalsManipulationProgramGroup;
import picard.cmdline.programgroups.OtherProgramGroup;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;
import picard.cmdline.programgroups.ReferenceProgramGroup;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;
import picard.cmdline.programgroups.VariantFilteringProgramGroup;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

public final class HelpConstants {
    public static final String GATK_FORUM_URL = "http://gatkforums.broadinstitute.org/";
    public static final String GATK_MAIN_SITE = "https://software.broadinstitute.org/gatk/";
    public static final String DOC_CAT_ANNOTATORS = "Variant Annotations";
    public static final String DOC_CAT_ANNOTATORS_SUMMARY = "Available to HaplotypeCaller, Mutect2, VariantAnnotator and GenotypeGVCFs. See https://software.broadinstitute.org/gatk/documentation/article?id=10836";
    public static final String DOC_CAT_COVERAGE_ANALYSIS = "Coverage Analysis";
    public static final String DOC_CAT_COVERAGE_ANALYSIS_SUMMARY = "Tools that count coverage, e.g. depth per allele";
    public static final String DOC_CAT_CNV = "Copy Number Variant Discovery";
    public static final String DOC_CAT_CNV_SUMMARY = "Tools that analyze read coverage to detect copy number variants.";
    public static final String DOC_CAT_EXAMPLE = "Example Tools";
    public static final String DOC_CAT_EXAMPLE_SUMMARY = "Example tools that show developers how to implement new tools";
    public static final String DOC_CAT_METAGENOMICS = "Metagenomics";
    public static final String DOC_CAT_METAGENOMICS_SUMMARY = "Tools that perform metagenomic analysis, e.g. microbial community composition and pathogen detection";
    public static final String DOC_CAT_READFILTERS = "Read Filters";
    public static final String DOC_CAT_READFILTERS_SUMMARY = "Applied by engine to select reads for analysis";
    public static final String DOC_CAT_SHORT_VARIANT_DISCOVERY = "Short Variant Discovery";
    public static final String DOC_CAT_SHORT_VARIANT_DISCOVERY_SUMMARY = "Tools that perform variant calling and genotyping for short variants (SNPs, SNVs and Indels)";
    public static final String DOC_CAT_SV_DISCOVERY = "Structural Variant Discovery";
    public static final String DOC_CAT_SV_DISCOVERY_SUMMARY = "Tools that detect structural variants";
    public static final String DOC_CAT_TEST = "Test Tools";
    public static final String DOC_CAT_TEST_SUMMARY = "Tools for internal test purposes";
    public static final String DOC_CAT_RNA = "RNA-Specific Tools";
    public static final String DOC_CAT_RNA_SUMMARY = "Tools intended to be used for processing RNA data.";
    public static final String DOC_CAT_METHYLATION_DISCOVERY = "Methylation-Specific Tools";
    public static final String DOC_CAT_METHYLATION_DISCOVERY_SUMMARY = "Tools that perform methylation calling, processing bisulfite sequenced, methylation-aware aligned BAM";
    private static final String DOC_SUPERCAT_TOOLS = "tools";
    private static final String DOC_SUPERCAT_UTILITIES = "utilities";
    private static final String DOC_SUPERCAT_EXCLUDE = "exclude";
    private static Map<String, String> groupToSuperCategory;

    private HelpConstants() {
    }

    public static String forumPost(String post) {
        return GATK_FORUM_URL + post;
    }

    private static Map<String, String> getSuperCategoryMap() {
        if (groupToSuperCategory == null) {
            groupToSuperCategory = new HashMap<String, String>();
            groupToSuperCategory.put(new DiagnosticsAndQCProgramGroup().getName(), DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(new IntervalsManipulationProgramGroup().getName(), DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(new OtherProgramGroup().getName(), DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(new ReadDataManipulationProgramGroup().getName(), DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(new ReferenceProgramGroup().getName(), DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(new VariantEvaluationProgramGroup().getName(), DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(new VariantFilteringProgramGroup().getName(), DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(new VariantManipulationProgramGroup().getName(), DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_CNV, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_COVERAGE_ANALYSIS, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_METAGENOMICS, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_SHORT_VARIANT_DISCOVERY, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_SV_DISCOVERY, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_READFILTERS, DOC_SUPERCAT_UTILITIES);
            groupToSuperCategory.put(DOC_CAT_ANNOTATORS, DOC_SUPERCAT_UTILITIES);
            groupToSuperCategory.put(DOC_CAT_EXAMPLE, DOC_SUPERCAT_EXCLUDE);
            groupToSuperCategory.put(DOC_CAT_TEST, DOC_SUPERCAT_EXCLUDE);
        }
        return groupToSuperCategory;
    }

    public static String getSuperCategoryProperty(String groupName) {
        Utils.nonNull(groupName);
        return HelpConstants.getSuperCategoryMap().getOrDefault(groupName, "other");
    }
}

