/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.io;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.utils.io.IOUtils;

class DeleteRecursivelyOnExitPathHook {
    private static final Logger LOG = LogManager.getLogger(DeleteRecursivelyOnExitPathHook.class);
    private static LinkedHashSet<Path> paths = new LinkedHashSet();

    private DeleteRecursivelyOnExitPathHook() {
    }

    public static synchronized void add(Path path) {
        if (paths == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        paths.add(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runHooks() {
        Class<DeleteRecursivelyOnExitPathHook> clazz = DeleteRecursivelyOnExitPathHook.class;
        synchronized (DeleteRecursivelyOnExitPathHook.class) {
            LinkedHashSet<Path> thePaths = paths;
            paths = null;
            // ** MonitorExit[var1] (shouldn't be in output)
            ArrayList<Path> toBeDeleted = new ArrayList<Path>(thePaths);
            Collections.reverse(toBeDeleted);
            for (Path path : toBeDeleted) {
                try {
                    IOUtils.deleteRecursively(path);
                }
                catch (Exception e) {
                    LOG.debug(() -> "Could not recursively delete " + path.toString() + " during JVM shutdown because we encountered the following exception:", (Throwable)e);
                }
            }
            return;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(DeleteRecursivelyOnExitPathHook::runHooks));
    }
}

