/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.io;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.PositionalOutputStream;
import htsjdk.tribble.Feature;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.tabix.TabixIndexCreator;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.function.Function;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;

public class FeatureOutputStream<F extends Feature>
implements Closeable {
    private static final String NEWLINE_CHARACTER = "\n";
    private final PositionalOutputStream outputStream;
    private final IndexCreator indexCreator;
    private final Function<F, String> encoder;
    private final Path featurePath;

    public FeatureOutputStream(GATKPath file, FeatureCodec<? extends Feature, ?> codec, Function<F, String> encoder, SAMSequenceDictionary dictionary, int compressionLevel) {
        Utils.nonNull(file);
        Utils.nonNull(codec);
        Utils.nonNull(encoder);
        Utils.nonNull(dictionary);
        if (IOUtil.hasBlockCompressedExtension((Path)file.toPath())) {
            this.outputStream = new PositionalOutputStream((OutputStream)new BlockCompressedOutputStream(file.toString(), compressionLevel));
            this.indexCreator = new TabixIndexCreator(dictionary, codec.getTabixFormat());
        } else {
            this.outputStream = new PositionalOutputStream(file.getOutputStream());
            this.indexCreator = null;
        }
        this.featurePath = file.toPath();
        this.encoder = encoder;
    }

    public void writeHeader(String header) {
        Utils.nonNull(header);
        try {
            this.outputStream.write((header + NEWLINE_CHARACTER).getBytes());
        }
        catch (IOException e) {
            throw new GATKException("Error writing header", e);
        }
    }

    public void add(F feature) {
        Utils.nonNull(feature);
        if (this.indexCreator != null) {
            this.indexCreator.addFeature(feature, this.outputStream.getPosition());
        }
        try {
            this.outputStream.write((this.encoder.apply(feature) + NEWLINE_CHARACTER).getBytes());
        }
        catch (IOException e) {
            throw new GATKException("Error writing record", e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.indexCreator != null) {
                Index index = this.indexCreator.finalizeIndex(this.outputStream.getPosition());
                index.writeBasedOnFeaturePath(this.featurePath);
            }
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new GATKException("Error closing output", e);
        }
    }
}

