/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.broadinstitute.hellbender.exceptions.GATKException;

public final class Resource {
    private final String path;
    private final Class<?> relativeClass;
    public static final String LARGE_RUNTIME_RESOURCES_PATH = "large";

    public Resource(String path, Class<?> relativeClass) {
        this.path = path;
        this.relativeClass = relativeClass;
    }

    public final Class<?> getRelativeClass() {
        return this.relativeClass;
    }

    public String getPath() {
        return this.path;
    }

    public String getFullPath() {
        if (this.relativeClass == null) {
            return this.path;
        }
        if (new File(this.path).isAbsolute()) {
            return this.path;
        }
        return String.format("%s%s%s", this.relativeClass.getPackage().getName().replace('.', File.separatorChar), File.separator, this.path);
    }

    public InputStream getResourceContentsAsStream() {
        InputStream inputStream;
        Class<?> clazz = this.getRelativeClass();
        if (clazz == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(this.path);
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found: " + this.path);
            }
        } else {
            inputStream = clazz.getResourceAsStream(this.path);
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found relative to " + clazz + ": " + this.path);
            }
        }
        return inputStream;
    }

    public static File getResourceContentsAsFile(String resourcePath) throws IOException {
        File tmpResourceFile = File.createTempFile("tmp_read_resource_", ".config");
        InputStream resourceAsStream = Resource.class.getClassLoader().getResourceAsStream(resourcePath);
        if (resourceAsStream == null) {
            throw new GATKException("Null value when trying to read resource.  Cannot find: " + resourcePath);
        }
        FileUtils.copyInputStreamToFile((InputStream)resourceAsStream, (File)tmpResourceFile);
        return tmpResourceFile;
    }
}

