/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.iterators;

import htsjdk.samtools.util.PeekableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;

public class AllLocusIterator
implements Iterator<AlignmentContext> {
    private final PeekableIterator<AlignmentContext> nestedLocusIterator;
    private final SimpleInterval interval;
    private int currentPosition;
    private AlignmentContext nextPileup;

    public AllLocusIterator(SimpleInterval interval, Iterator<AlignmentContext> nestedLocusIterator) {
        Utils.nonNull(interval);
        Utils.nonNull(nestedLocusIterator);
        this.nestedLocusIterator = new PeekableIterator(nestedLocusIterator);
        this.interval = interval;
        this.currentPosition = interval.getStart();
        if (this.nestedLocusIterator.peek() != null && !((AlignmentContext)this.nestedLocusIterator.peek()).getContig().equals(interval.getContig())) {
            throw new IllegalArgumentException("Locus iterator must be over the same contig as the interval provided");
        }
        this.nextPileup = this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.nextPileup != null;
    }

    @Override
    public AlignmentContext next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next() called when there are no more items");
        }
        AlignmentContext toReturn = this.nextPileup;
        this.nextPileup = this.advance();
        return toReturn;
    }

    private AlignmentContext advance() {
        if (this.currentPosition > this.interval.getEnd()) {
            while (this.nestedLocusIterator.hasNext()) {
                this.nestedLocusIterator.next();
            }
            return null;
        }
        while (this.nestedLocusIterator.hasNext() && ((AlignmentContext)this.nestedLocusIterator.peek()).getStart() < this.currentPosition) {
            this.nestedLocusIterator.next();
        }
        AlignmentContext nextNestedPileup = (AlignmentContext)this.nestedLocusIterator.peek();
        AlignmentContext toReturn = nextNestedPileup == null ? this.createEmptyAlignmentContextForPosition(this.currentPosition) : (nextNestedPileup.getStart() == this.currentPosition ? (AlignmentContext)this.nestedLocusIterator.next() : this.createEmptyAlignmentContextForPosition(this.currentPosition));
        ++this.currentPosition;
        return toReturn;
    }

    private AlignmentContext createEmptyAlignmentContextForPosition(int position) {
        SimpleInterval positionInterval = new SimpleInterval(this.interval.getContig(), position, position);
        return new AlignmentContext(positionInterval, new ReadPileup(positionInterval));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported");
    }
}

