/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.utils.Utils;

public final class ByteArrayIterator
implements Iterator<Byte> {
    private final byte[] byteArray;
    private int currentPosition;
    private int stopIndex;

    public ByteArrayIterator(byte[] byteArray) {
        this(byteArray, 0, byteArray.length);
    }

    public ByteArrayIterator(byte[] byteArray, int firstIndex, int stopIndex) {
        if (byteArray.length != 0 || firstIndex != 0) {
            Utils.validIndex(firstIndex, byteArray.length);
        }
        Utils.validateArg(stopIndex <= byteArray.length, () -> "stopIndex is " + stopIndex + " yet we only have " + byteArray.length + " bytes.");
        Utils.validateArg(stopIndex >= firstIndex, () -> "stopIndex<firstIndex (" + stopIndex + "<" + firstIndex + ")");
        this.byteArray = byteArray;
        this.currentPosition = firstIndex;
        this.stopIndex = stopIndex;
    }

    @Override
    public boolean hasNext() {
        return this.currentPosition < this.stopIndex;
    }

    @Override
    public Byte next() {
        if (this.currentPosition >= this.stopIndex) {
            throw new NoSuchElementException("No more elements in byte array");
        }
        return this.byteArray[this.currentPosition++];
    }
}

