/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.iterators;

import java.util.Iterator;
import java.util.function.Consumer;

public class CloseAtEndIterator<E>
implements Iterator<E> {
    private final Iterator<E> iterator;
    private final AutoCloseable closeable;

    public CloseAtEndIterator(Iterator<E> iterator, AutoCloseable closeable) {
        this.iterator = iterator;
        this.closeable = closeable;
    }

    @Override
    public boolean hasNext() {
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            try {
                this.closeable.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return hasNext;
    }

    @Override
    public E next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        this.iterator.forEachRemaining(action);
    }
}

