/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.iterators;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.iterators.ShardedIntervalIterator;

public class IntervalLocusIterator
implements Iterator<SimpleInterval> {
    private Iterator<SimpleInterval> intervalIterator;
    public SimpleInterval currentInterval = null;
    private Iterator<SimpleInterval> baseLocationIterator;

    public IntervalLocusIterator(Iterator<SimpleInterval> intervalIterator) {
        Utils.nonNull(intervalIterator, "Input iterator cannot be null");
        this.intervalIterator = intervalIterator;
        this.advanceCurrentInterval();
    }

    @Override
    public boolean hasNext() {
        if (this.currentInterval == null) {
            return false;
        }
        return this.baseLocationIterator.hasNext() || this.intervalIterator.hasNext();
    }

    @Override
    public SimpleInterval next() {
        if (this.baseLocationIterator.hasNext()) {
            return this.baseLocationIterator.next();
        }
        if (this.intervalIterator.hasNext()) {
            this.advanceCurrentInterval();
            return this.baseLocationIterator.next();
        }
        throw new NoSuchElementException();
    }

    private void advanceCurrentInterval() {
        this.currentInterval = this.intervalIterator.hasNext() ? this.intervalIterator.next() : null;
        this.baseLocationIterator = this.createBaseLocationIterator(this.currentInterval);
    }

    private Iterator<SimpleInterval> createBaseLocationIterator(SimpleInterval fullInterval) {
        if (fullInterval == null) {
            return Collections.emptyList().iterator();
        }
        List<SimpleInterval> dummyList = Collections.singletonList(fullInterval);
        return new ShardedIntervalIterator(dummyList.iterator(), 1);
    }
}

