/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.iterators;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public class IntervalOverlappingIterator<T extends Locatable>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final Iterator<SimpleInterval> intervals;
    private SimpleInterval currentInterval;
    private final SAMSequenceDictionary dictionary;
    private T next;

    public IntervalOverlappingIterator(Iterator<T> iterator, List<SimpleInterval> intervals, SAMSequenceDictionary dictionary) {
        Utils.nonNull(iterator);
        Utils.nonEmpty(intervals);
        Utils.nonNull(dictionary);
        this.iterator = iterator;
        this.intervals = intervals.iterator();
        this.dictionary = dictionary;
        this.currentInterval = this.intervals.next();
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T toReturn = this.next;
        this.advance();
        return toReturn;
    }

    private void advance() {
        Object object = this.next = this.iterator.hasNext() ? (Locatable)this.iterator.next() : null;
        while (this.next != null && this.currentInterval != null) {
            if (this.currentInterval.overlaps((Locatable)this.next)) {
                return;
            }
            int comparison = IntervalUtils.compareLocatables(this.currentInterval, this.next, this.dictionary);
            if (comparison < 0) {
                this.currentInterval = this.intervals.hasNext() ? this.intervals.next() : null;
                continue;
            }
            if (comparison <= 0) continue;
            this.next = this.iterator.hasNext() ? (Locatable)this.iterator.next() : null;
        }
        this.next = null;
    }
}

