/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.iterators;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.iterators.PushPullTransformer;

public class PushToPullIterator<T>
implements Iterator<T>,
Iterable<T> {
    private final Iterator<T> inputElements;
    private final PushPullTransformer<T> transformer;
    private Iterator<T> cachedElements = null;
    private T nextElement = null;

    public PushToPullIterator(Iterator<T> inputElements, PushPullTransformer<T> transformer) {
        Utils.nonNull(inputElements, "iterator must not be null");
        Utils.nonNull(transformer, "transformer must not be null");
        this.inputElements = inputElements;
        this.transformer = transformer;
        this.advanceToNextElement();
    }

    @Override
    public boolean hasNext() {
        return this.nextElement != null;
    }

    @Override
    public T next() {
        if (this.nextElement == null) {
            throw new NoSuchElementException("next() called when there are no more items");
        }
        T toReturn = this.nextElement;
        this.advanceToNextElement();
        return toReturn;
    }

    private void advanceToNextElement() {
        this.nextElement = this.readyToReleaseItems() || this.fillCache() ? this.cachedElements.next() : null;
    }

    private boolean readyToReleaseItems() {
        return this.cachedElements != null && this.cachedElements.hasNext();
    }

    private boolean fillCache() {
        while (this.inputElements.hasNext() && !this.transformer.hasFinalizedItems()) {
            this.transformer.submit(this.inputElements.next());
        }
        if (!this.inputElements.hasNext()) {
            this.transformer.signalEndOfInput();
        }
        List<T> transformedElements = this.transformer.consumeFinalizedItems();
        this.cachedElements = transformedElements.iterator();
        return this.cachedElements.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove records via a Push");
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

