/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.iterators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class ReadCachingIterator
implements Iterator<GATKRead> {
    private final Iterator<GATKRead> wrappedIter;
    private List<GATKRead> cache;
    private static final int INITIAL_CACHE_CAPACITY = 10000;

    public ReadCachingIterator(Iterator<GATKRead> wrappedIter) {
        this.wrappedIter = wrappedIter;
        this.cache = new ArrayList<GATKRead>(10000);
    }

    @Override
    public boolean hasNext() {
        return this.wrappedIter.hasNext();
    }

    @Override
    public GATKRead next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("next() called when there are no more items");
        }
        GATKRead nextRead = this.wrappedIter.next();
        this.cache.add(nextRead);
        return nextRead;
    }

    public List<GATKRead> consumeCachedReads() {
        List<GATKRead> oldCache = this.cache;
        this.cache = new ArrayList<GATKRead>(10000);
        return oldCache;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported");
    }
}

