/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.engine.filters.ReadFilter;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class ReadFilteringIterator
implements Iterator<GATKRead>,
Iterable<GATKRead> {
    private final Iterator<GATKRead> nestedIterator;
    private final ReadFilter readFilter;
    private GATKRead nextRead;

    public ReadFilteringIterator(Iterator<GATKRead> nestedIterator, ReadFilter readFilter) {
        Utils.nonNull(nestedIterator);
        Utils.nonNull(readFilter);
        this.nestedIterator = nestedIterator;
        this.readFilter = readFilter;
        this.nextRead = this.loadNextRead();
    }

    @Override
    public boolean hasNext() {
        return this.nextRead != null;
    }

    @Override
    public GATKRead next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Iterator exhausted");
        }
        GATKRead toReturn = this.nextRead;
        this.nextRead = this.loadNextRead();
        return toReturn;
    }

    private GATKRead loadNextRead() {
        while (this.nestedIterator.hasNext()) {
            GATKRead candidate = this.nestedIterator.next();
            if (!this.readFilter.test(candidate)) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public Iterator<GATKRead> iterator() {
        return this;
    }
}

