/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.transformers.ReadTransformer;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class ReadTransformingIterator
implements Iterator<GATKRead>,
Iterable<GATKRead> {
    private final Iterator<GATKRead> nestedIterator;
    private final ReadTransformer readTransformer;

    public ReadTransformingIterator(Iterator<GATKRead> nestedIterator, ReadTransformer readTransformer) {
        this.nestedIterator = Utils.nonNull(nestedIterator);
        this.readTransformer = Utils.nonNull(readTransformer);
    }

    @Override
    public boolean hasNext() {
        return this.nestedIterator.hasNext();
    }

    @Override
    public GATKRead next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Iterator exhausted");
        }
        return (GATKRead)this.readTransformer.apply(this.nestedIterator.next());
    }

    @Override
    public Iterator<GATKRead> iterator() {
        return this;
    }
}

