/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.iterators;

import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.CloseableIterator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.TraversalParameters;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public class SamReaderQueryingIterator
implements CloseableIterator<SAMRecord>,
Iterable<SAMRecord> {
    private static int NUMBER_OF_TRAVESAL_INTERVALS_WORTH_LOGGING_A_DEBUG_MESSAGE_OF_THEIR_PREPARATION = 1000;
    protected static final Logger logger = LogManager.getLogger(SamReaderQueryingIterator.class);
    private final SamReader reader;
    private final QueryInterval[] queryIntervals;
    private final boolean queryUnmapped;
    private CloseableIterator<SAMRecord> currentIterator;
    private SAMRecord nextRecord;
    private boolean intervalQueryPerformed;
    private boolean unmappedQueryPerformed;

    public SamReaderQueryingIterator(SamReader reader, List<SimpleInterval> queryIntervals, boolean queryUnmapped) {
        Utils.nonNull(reader);
        this.reader = reader;
        this.queryIntervals = this.prepareQueryIntervals(queryIntervals);
        this.queryUnmapped = queryUnmapped;
        this.intervalQueryPerformed = false;
        this.unmappedQueryPerformed = false;
        this.currentIterator = this.loadNextIterator();
        this.nextRecord = this.loadNextRecord();
    }

    public SamReaderQueryingIterator(SamReader reader, TraversalParameters traversalParameters) {
        this(reader, traversalParameters.getIntervalsForTraversal(), traversalParameters.traverseUnmappedReads());
    }

    private QueryInterval[] prepareQueryIntervals(List<SimpleInterval> rawIntervals) {
        if (rawIntervals == null || rawIntervals.isEmpty()) {
            return null;
        }
        if (rawIntervals.size() >= NUMBER_OF_TRAVESAL_INTERVALS_WORTH_LOGGING_A_DEBUG_MESSAGE_OF_THEIR_PREPARATION) {
            logger.debug("Preparing intervals for traversal");
        }
        QueryInterval[] convertedIntervals = (QueryInterval[])rawIntervals.stream().map(rawInterval -> IntervalUtils.convertSimpleIntervalToQueryInterval(rawInterval, this.reader.getFileHeader().getSequenceDictionary())).toArray(QueryInterval[]::new);
        return QueryInterval.optimizeIntervals((QueryInterval[])convertedIntervals);
    }

    private SAMRecord loadNextRecord() {
        if (this.currentIterator == null) {
            return null;
        }
        while (this.currentIterator != null && !this.currentIterator.hasNext()) {
            this.currentIterator = this.loadNextIterator();
        }
        return this.currentIterator != null ? (SAMRecord)this.currentIterator.next() : null;
    }

    private CloseableIterator<SAMRecord> loadNextIterator() {
        if (this.currentIterator != null) {
            this.currentIterator.close();
        }
        if (this.hasQueryIntervals() && !this.intervalQueryPerformed) {
            this.intervalQueryPerformed = true;
            return this.reader.queryOverlapping(this.queryIntervals);
        }
        if (this.queryUnmapped && !this.unmappedQueryPerformed) {
            this.unmappedQueryPerformed = true;
            return this.reader.queryUnmapped();
        }
        return null;
    }

    private boolean hasQueryIntervals() {
        return this.queryIntervals != null && this.queryIntervals.length > 0;
    }

    public boolean hasNext() {
        return this.nextRecord != null;
    }

    public SAMRecord next() {
        if (this.nextRecord == null) {
            throw new NoSuchElementException("Iterator is exhausted");
        }
        SAMRecord toReturn = this.nextRecord;
        this.nextRecord = this.loadNextRecord();
        return toReturn;
    }

    public void close() {
        if (this.currentIterator != null) {
            this.currentIterator.close();
        }
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return this;
    }
}

