/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public class ShardedIntervalIterator
implements Iterator<SimpleInterval> {
    private Iterator<SimpleInterval> intervals;
    private int shardSize;
    private SimpleInterval currentInterval;
    private int currentOffsetInCurrentInterval;
    private int lastOffsetInCurrentInterval;
    private SimpleInterval shardedInterval;

    public ShardedIntervalIterator(Iterator<SimpleInterval> intervals, int shardSizeInBases) {
        Utils.validate(shardSizeInBases > 0, "Invalid shard size.  Must be greater than zero.");
        this.intervals = intervals;
        this.shardSize = shardSizeInBases;
        this.currentOffsetInCurrentInterval = 0;
        this.lastOffsetInCurrentInterval = 0;
        this.currentInterval = null;
        this.shardedInterval = null;
        this.advanceInterval();
    }

    private void advanceInterval() {
        if (this.intervals.hasNext()) {
            this.currentInterval = this.intervals.next();
            this.currentOffsetInCurrentInterval = IntervalUtils.shardIndex(1, this.shardSize);
            this.lastOffsetInCurrentInterval = IntervalUtils.shardIndex(this.currentInterval.size(), this.shardSize);
            this.shardedInterval = this.calculateShardedInterval();
        } else {
            this.lastOffsetInCurrentInterval = 0;
            this.currentInterval = null;
            this.shardedInterval = null;
        }
    }

    private SimpleInterval calculateShardedInterval() {
        return new SimpleInterval(this.currentInterval.getContig(), this.currentInterval.getStart() + IntervalUtils.beginOfShard(this.currentOffsetInCurrentInterval, this.shardSize) - 1, Integer.min(this.currentInterval.getStart() + IntervalUtils.endOfShard(this.currentOffsetInCurrentInterval, this.shardSize) - 1, this.currentInterval.getEnd()));
    }

    @Override
    public boolean hasNext() {
        return this.shardedInterval != null;
    }

    @Override
    public SimpleInterval next() {
        if (this.shardedInterval == null) {
            throw new NoSuchElementException();
        }
        SimpleInterval result = this.shardedInterval;
        this.advanceShardInInterval();
        return result;
    }

    private void advanceShardInInterval() {
        ++this.currentOffsetInCurrentInterval;
        if (this.currentOffsetInCurrentInterval > this.lastOffsetInCurrentInterval) {
            this.advanceInterval();
        }
        this.shardedInterval = this.currentInterval != null ? this.calculateShardedInterval() : null;
    }
}

