/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.locusiterator;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.iterators.IntervalLocusIterator;
import org.broadinstitute.hellbender.utils.iterators.IntervalOverlappingIterator;
import org.broadinstitute.hellbender.utils.locusiterator.IntervalAlignmentContextIterator;
import org.broadinstitute.hellbender.utils.locusiterator.LIBSDownsamplingInfo;
import org.broadinstitute.hellbender.utils.locusiterator.LocusIteratorByState;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public class AlignmentContextIteratorBuilder {
    protected static final Logger logger = LogManager.getLogger(AlignmentContextIteratorBuilder.class);
    private boolean isEmitEmptyLoci = false;
    private boolean isKeepUniqueReadListInLibs = false;
    private boolean isIncludeDeletions = true;
    private boolean isIncludeNs = false;
    private LIBSDownsamplingInfo downsamplingInfo = LocusIteratorByState.NO_DOWNSAMPLING;

    public void setEmitEmptyLoci(boolean emitEmptyLoci) {
        this.isEmitEmptyLoci = emitEmptyLoci;
    }

    public void setKeepUniqueReadListInLibs(boolean keepUniqueReadListInLibs) {
        this.isKeepUniqueReadListInLibs = keepUniqueReadListInLibs;
    }

    public void setIncludeDeletions(boolean includeDeletions) {
        this.isIncludeDeletions = includeDeletions;
    }

    public void setIncludeNs(boolean includeNs) {
        this.isIncludeNs = includeNs;
    }

    public void setDownsamplingInfo(LIBSDownsamplingInfo downsamplingInfo) {
        this.downsamplingInfo = downsamplingInfo;
    }

    public Iterator<AlignmentContext> build(Iterator<GATKRead> readIterator, SAMFileHeader header, List<SimpleInterval> intervalsForTraversal, SAMSequenceDictionary dictionary, boolean isReference) {
        Utils.nonNull(header, "Header cannot be null");
        Utils.nonNull(readIterator, "Read iterator cannot be null");
        boolean isDefinitelyReference = dictionary != null && isReference;
        return AlignmentContextIteratorBuilder.createAlignmentContextIterator(intervalsForTraversal, header, readIterator, dictionary, this.downsamplingInfo, isDefinitelyReference, this.isEmitEmptyLoci, this.isKeepUniqueReadListInLibs, this.isIncludeDeletions, this.isIncludeNs);
    }

    private static Iterator<AlignmentContext> createAlignmentContextIterator(List<SimpleInterval> intervalsForTraversal, SAMFileHeader header, Iterator<GATKRead> readIterator, SAMSequenceDictionary dictionary, LIBSDownsamplingInfo downsamplingInfo, boolean isReference, boolean emitEmptyLoci, boolean isKeepUniqueReadListInLibs, boolean isIncludeDeletions, boolean isIncludeNs) {
        Set<String> samples = header.getReadGroups().stream().map(SAMReadGroupRecord::getSample).collect(Collectors.toSet());
        LocusIteratorByState libs = new LocusIteratorByState(readIterator, downsamplingInfo, isKeepUniqueReadListInLibs, samples, header, isIncludeDeletions, isIncludeNs);
        List<SimpleInterval> finalIntervals = intervalsForTraversal;
        AlignmentContextIteratorBuilder.validateEmitEmptyLociParameters(emitEmptyLoci, dictionary, intervalsForTraversal, isReference);
        if (emitEmptyLoci) {
            if (!AlignmentContextIteratorBuilder.areIntervalsSpecified(finalIntervals)) {
                finalIntervals = IntervalUtils.getAllIntervalsForReference(dictionary);
            }
            IntervalLocusIterator intervalLocusIterator = new IntervalLocusIterator(finalIntervals.iterator());
            return new IntervalAlignmentContextIterator(libs, intervalLocusIterator, header.getSequenceDictionary());
        }
        if (AlignmentContextIteratorBuilder.areIntervalsSpecified(finalIntervals)) {
            return new IntervalOverlappingIterator<AlignmentContext>(libs, finalIntervals, header.getSequenceDictionary());
        }
        return libs;
    }

    private static boolean areIntervalsSpecified(List<SimpleInterval> finalIntervals) {
        return finalIntervals != null;
    }

    private static void validateEmitEmptyLociParameters(boolean emitEmptyLoci, SAMSequenceDictionary dictionary, List<SimpleInterval> intervals, boolean isReference) {
        if (emitEmptyLoci) {
            if (dictionary == null && !isReference) {
                throw new UserException.MissingReference("No sequence dictionary nor reference specified.  Therefore, emitting empty loci is impossible and this tool cannot be run.  The easiest fix here is to specify a reference dictionary.");
            }
            if (!isReference && !AlignmentContextIteratorBuilder.areIntervalsSpecified(intervals)) {
                logger.warn("****************************************");
                logger.warn("* Running this tool without a reference nor intervals can yield unexpected results, since it will emit results for loci with no reads.  A sequence dictionary has been found and the intervals will be derived from this.  The easiest way avoid this message is to specify a reference.");
                logger.warn("****************************************");
            }
        }
    }
}

