/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.locusiterator;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.read.GATKRead;

public final class AlignmentStateMachine {
    private final GATKRead read;
    private final Cigar cigar;
    private final int nCigarElements;
    private int currentCigarElementOffset = -1;
    private int readOffset;
    private int genomeOffset;
    private CigarElement currentElement;
    private int offsetIntoCurrentCigarElement;

    public AlignmentStateMachine(GATKRead read) {
        this.read = read;
        this.cigar = read.getCigar();
        this.nCigarElements = this.cigar.numCigarElements();
        this.initializeAsLeftEdge();
    }

    private void initializeAsLeftEdge() {
        this.genomeOffset = -1;
        this.offsetIntoCurrentCigarElement = -1;
        this.readOffset = -1;
        this.currentElement = null;
    }

    public GATKRead getRead() {
        return this.read;
    }

    public String getContig() {
        return this.getRead().getContig();
    }

    public boolean isLeftEdge() {
        return this.readOffset == -1;
    }

    public boolean isRightEdge() {
        return this.readOffset == this.read.getLength();
    }

    public int getReadOffset() {
        return this.readOffset;
    }

    public int getGenomeOffset() {
        return this.genomeOffset;
    }

    public int getGenomePosition() {
        return this.read.getStart() + this.getGenomeOffset();
    }

    public SimpleInterval getLocation() {
        return new SimpleInterval(this.read.getContig(), this.getGenomePosition(), this.getGenomePosition());
    }

    public CigarElement getCurrentCigarElement() {
        return this.currentElement;
    }

    public int getCurrentCigarElementOffset() {
        return this.currentCigarElementOffset;
    }

    public int getOffsetIntoCurrentCigarElement() {
        return this.offsetIntoCurrentCigarElement;
    }

    public CigarOperator getCigarOperator() {
        return this.currentElement == null ? null : this.currentElement.getOperator();
    }

    public String toString() {
        return String.format("%s ro=%d go=%d cec=%d %s", this.read.getName(), this.readOffset, this.genomeOffset, this.offsetIntoCurrentCigarElement, this.currentElement);
    }

    public CigarOperator stepForwardOnGenome() {
        while (true) {
            if (this.currentElement == null || this.offsetIntoCurrentCigarElement + 1 >= this.currentElement.getLength()) {
                ++this.currentCigarElementOffset;
                if (this.currentCigarElementOffset < this.nCigarElements) {
                    this.currentElement = this.cigar.getCigarElement(this.currentCigarElementOffset);
                    this.offsetIntoCurrentCigarElement = -1;
                    continue;
                }
                if (this.currentElement != null && this.currentElement.getOperator() == CigarOperator.D) {
                    throw new UserException.MalformedRead(this.read, "read ends with deletion. Cigar: " + this.read.getCigar().toString() + ". Although the SAM spec technically permits such reads, this is often indicative of malformed files.");
                }
                this.offsetIntoCurrentCigarElement = 0;
                this.readOffset = this.read.getLength();
                this.currentElement = null;
                ++this.genomeOffset;
                return null;
            }
            ++this.offsetIntoCurrentCigarElement;
            boolean done = false;
            switch (this.currentElement.getOperator()) {
                case H: 
                case P: {
                    this.offsetIntoCurrentCigarElement = this.currentElement.getLength();
                    break;
                }
                case I: 
                case S: {
                    this.offsetIntoCurrentCigarElement = this.currentElement.getLength();
                    this.readOffset += this.currentElement.getLength();
                    break;
                }
                case D: {
                    if (this.readOffset < 0) {
                        throw new UserException.MalformedRead(this.read, "read starts with deletion. Cigar: " + this.read.getCigar().toString() + ". Although the SAM spec technically permits such reads, this is often indicative of malformed files.");
                    }
                    ++this.genomeOffset;
                    done = true;
                    break;
                }
                case N: {
                    ++this.genomeOffset;
                    done = true;
                    break;
                }
                case M: 
                case EQ: 
                case X: {
                    ++this.readOffset;
                    ++this.genomeOffset;
                    done = true;
                    break;
                }
                default: {
                    throw new IllegalStateException("Case statement didn't deal with cigar op: " + this.currentElement.getOperator());
                }
            }
            if (done) break;
        }
        return this.currentElement.getOperator();
    }

    public final PileupElement makePileupElement() {
        Utils.validate(!this.isLeftEdge() && !this.isRightEdge(), "Cannot make a pileup element from an edge alignment state");
        return new PileupElement(this.read, this.getReadOffset(), this.getCurrentCigarElement(), this.getCurrentCigarElementOffset(), this.getOffsetIntoCurrentCigarElement());
    }
}

