/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.locusiterator;

import htsjdk.samtools.SAMSequenceDictionary;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.utils.IntervalUtils;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.iterators.IntervalLocusIterator;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;

public class IntervalAlignmentContextIterator
implements Iterator<AlignmentContext> {
    private Iterator<AlignmentContext> alignmentContextIterator;
    private IntervalLocusIterator intervalLocusIterator;
    private SimpleInterval currentInterval;
    private AlignmentContext currentAlignmentContext;
    private SAMSequenceDictionary dictionary;

    public IntervalAlignmentContextIterator(Iterator<AlignmentContext> alignmentContextIterator, IntervalLocusIterator intervalLocusIterator, SAMSequenceDictionary dictionary) {
        this.alignmentContextIterator = alignmentContextIterator;
        this.intervalLocusIterator = intervalLocusIterator;
        this.dictionary = dictionary;
        this.advanceIntervalLocus();
        this.advanceAlignmentContext();
        this.advanceAlignmentContextToCurrentInterval();
    }

    @Override
    public boolean hasNext() {
        return this.currentInterval != null;
    }

    @Override
    public AlignmentContext next() {
        AlignmentContext result;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        boolean isOverlaps = this.currentInterval.overlaps(this.currentAlignmentContext);
        if (isOverlaps) {
            result = this.currentAlignmentContext;
            this.advanceIntervalLocus();
            this.advanceAlignmentContextToCurrentInterval();
        } else {
            int comparison;
            result = this.createEmptyAlignmentContext(this.currentInterval);
            this.advanceIntervalLocus();
            if (this.currentInterval != null && (comparison = IntervalUtils.compareLocatables(this.currentInterval, this.currentAlignmentContext, this.dictionary)) > 0) {
                this.advanceAlignmentContextToCurrentInterval();
            }
        }
        return result;
    }

    private AlignmentContext createEmptyAlignmentContext(SimpleInterval interval) {
        return new AlignmentContext(interval, new ReadPileup(interval));
    }

    private void advanceAlignmentContextToCurrentInterval() {
        if (this.currentInterval == null) {
            this.currentAlignmentContext = null;
            return;
        }
        while (IntervalUtils.compareLocatables(this.currentInterval, this.currentAlignmentContext, this.dictionary) > 0) {
            this.advanceAlignmentContext();
        }
    }

    private void advanceAlignmentContext() {
        this.currentAlignmentContext = this.alignmentContextIterator.hasNext() ? this.alignmentContextIterator.next() : this.createEmptyAlignmentContext(this.currentInterval);
    }

    private void advanceIntervalLocus() {
        this.currentInterval = this.intervalLocusIterator.hasNext() ? this.intervalLocusIterator.next() : null;
    }
}

