/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.locusiterator;

import java.io.Serializable;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.DownsampleType;
import org.broadinstitute.hellbender.utils.downsampling.DownsamplingMethod;

public final class LIBSDownsamplingInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean performDownsampling;
    private final int toCoverage;

    public LIBSDownsamplingInfo(boolean performDownsampling, int toCoverage) {
        Utils.validateArg(toCoverage >= -1, "toCoverage must be at least -1 (special value) but was " + toCoverage);
        this.performDownsampling = performDownsampling;
        this.toCoverage = toCoverage;
    }

    public boolean isPerformDownsampling() {
        return this.performDownsampling;
    }

    public int getToCoverage() {
        return this.toCoverage;
    }

    public static LIBSDownsamplingInfo toDownsamplingInfo(DownsamplingMethod downsamplingMethod) {
        boolean performDownsampling = downsamplingMethod != null && downsamplingMethod.type == DownsampleType.BY_SAMPLE && downsamplingMethod.toCoverage != null;
        int toCoverage = performDownsampling ? downsamplingMethod.toCoverage : 0;
        return new LIBSDownsamplingInfo(performDownsampling, toCoverage);
    }
}

