/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.locusiterator;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.Locatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.engine.AlignmentContext;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.DownsamplingMethod;
import org.broadinstitute.hellbender.utils.locusiterator.AlignmentStateMachine;
import org.broadinstitute.hellbender.utils.locusiterator.LIBSDownsamplingInfo;
import org.broadinstitute.hellbender.utils.locusiterator.PerSampleReadStateManager;
import org.broadinstitute.hellbender.utils.locusiterator.ReadStateManager;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.pileup.ReadPileup;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

public final class LocusIteratorByState
implements Iterator<AlignmentContext> {
    public static final LIBSDownsamplingInfo NO_DOWNSAMPLING = new LIBSDownsamplingInfo(false, -1);
    private static final Logger logger = LogManager.getLogger(LocusIteratorByState.class);
    private final List<String> samples;
    private final ReadStateManager readStates;
    private final boolean includeReadsWithDeletionAtLoci;
    private final boolean includeReadsWithNsAtLoci;
    private AlignmentContext nextAlignmentContext;

    public LocusIteratorByState(Iterator<GATKRead> samIterator, DownsamplingMethod downsamplingMethod, boolean keepUniqueReadListInLIBS, Collection<String> samples, SAMFileHeader header, boolean includeReadsWithDeletionAtLoci) {
        this(samIterator, LIBSDownsamplingInfo.toDownsamplingInfo(downsamplingMethod), keepUniqueReadListInLIBS, samples, header, includeReadsWithDeletionAtLoci);
    }

    public LocusIteratorByState(Iterator<GATKRead> samIterator, DownsamplingMethod downsamplingMethod, boolean keepUniqueReadListInLIBS, Collection<String> samples, SAMFileHeader header, boolean includeReadsWithDeletionAtLoci, boolean includeReadsWithNsAtLoci) {
        this(samIterator, LIBSDownsamplingInfo.toDownsamplingInfo(downsamplingMethod), keepUniqueReadListInLIBS, samples, header, includeReadsWithDeletionAtLoci, includeReadsWithNsAtLoci);
    }

    public LocusIteratorByState(Iterator<GATKRead> samIterator, LIBSDownsamplingInfo downsamplingInfo, boolean keepUniqueReadListInLIBS, Collection<String> samples, SAMFileHeader header, boolean includeReadsWithDeletionAtLoci) {
        this(samIterator, downsamplingInfo, keepUniqueReadListInLIBS, samples, header, includeReadsWithDeletionAtLoci, false);
    }

    public LocusIteratorByState(Iterator<GATKRead> samIterator, LIBSDownsamplingInfo downsamplingInfo, boolean keepUniqueReadListInLIBS, Collection<String> samples, SAMFileHeader header, boolean includeReadsWithDeletionAtLoci, boolean includeReadsWithNsAtLoci) {
        Utils.nonNull(samIterator, "samIterator cannot be null");
        Utils.nonNull(downsamplingInfo, "downsamplingInfo cannot be null");
        Utils.nonNull(samples, "Samples cannot be null");
        Utils.nonNull(header, "header cannot be null");
        if (samples.isEmpty() && samIterator.hasNext()) {
            throw new IllegalArgumentException("samples list must not be empty");
        }
        this.includeReadsWithDeletionAtLoci = includeReadsWithDeletionAtLoci;
        this.includeReadsWithNsAtLoci = includeReadsWithNsAtLoci;
        this.samples = new ArrayList<String>(samples);
        this.readStates = new ReadStateManager(samIterator, this.samples, downsamplingInfo, keepUniqueReadListInLIBS, header);
    }

    private SimpleInterval getLocation() {
        return this.readStates.isEmpty() ? null : this.readStates.getFirst().getLocation();
    }

    @Override
    public boolean hasNext() {
        this.lazyLoadNextAlignmentContext();
        return this.nextAlignmentContext != null;
    }

    @Override
    public AlignmentContext next() {
        this.lazyLoadNextAlignmentContext();
        if (!this.hasNext()) {
            throw new NoSuchElementException("LocusIteratorByState: out of elements.");
        }
        AlignmentContext currentAlignmentContext = this.nextAlignmentContext;
        this.nextAlignmentContext = null;
        return currentAlignmentContext;
    }

    public AlignmentContext advanceToLocus(int position, boolean stopAtFirstNonEmptySiteAfterPosition) {
        while (this.hasNext()) {
            AlignmentContext context = this.next();
            if (context == null) {
                return null;
            }
            if (context.getPosition() == (long)position) {
                return context;
            }
            if (context.getPosition() <= (long)position) continue;
            return stopAtFirstNonEmptySiteAfterPosition ? context : null;
        }
        return null;
    }

    private void lazyLoadNextAlignmentContext() {
        while (this.nextAlignmentContext == null && this.readStates.hasNext()) {
            this.readStates.collectPendingReads();
            SimpleInterval location = this.getLocation();
            ArrayList<PileupElement> allPileupElements = new ArrayList<PileupElement>(100);
            for (Map.Entry<String, PerSampleReadStateManager> sampleStatePair : this.readStates) {
                PerSampleReadStateManager readState = sampleStatePair.getValue();
                for (AlignmentStateMachine state : readState) {
                    GATKRead read = state.getRead();
                    CigarOperator op = state.getCigarOperator();
                    if (!this.includeReadsWithNsAtLoci && op == CigarOperator.N || this.dontIncludeReadInPileup(read, location.getStart()) || !this.includeReadsWithDeletionAtLoci && op == CigarOperator.D) continue;
                    allPileupElements.add(state.makePileupElement());
                }
            }
            this.readStates.updateReadStates();
            if (allPileupElements.isEmpty()) continue;
            this.nextAlignmentContext = new AlignmentContext(location, new ReadPileup((Locatable)location, (List<PileupElement>)allPileupElements));
        }
    }

    private boolean dontIncludeReadInPileup(GATKRead rec, long pos) {
        return ReadUtils.isBaseInsideAdaptor(rec, pos);
    }

    public List<GATKRead> transferReadsFromAllPreviousPileups() {
        return this.readStates.transferSubmittedReads();
    }

    @VisibleForTesting
    List<GATKRead> getReadsFromAllPreviousPileups() {
        return this.readStates.getSubmittedReads();
    }
}

