/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.locusiterator;

import htsjdk.samtools.CigarOperator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.Downsampler;
import org.broadinstitute.hellbender.utils.downsampling.LevelingDownsampler;
import org.broadinstitute.hellbender.utils.locusiterator.AlignmentStateMachine;
import org.broadinstitute.hellbender.utils.locusiterator.LIBSDownsamplingInfo;

final class PerSampleReadStateManager
implements Iterable<AlignmentStateMachine> {
    private static final Logger logger = LogManager.getLogger(PerSampleReadStateManager.class);
    private static final boolean CAPTURE_DOWNSAMPLING_STATS = false;
    private List<AlignmentStateMachine> readStatesByAlignmentStart = new LinkedList<AlignmentStateMachine>();
    private final Downsampler<LinkedList<AlignmentStateMachine>> levelingDownsampler;
    private final int downsamplingTarget;
    private int nSitesNeedingDownsampling = 0;
    private int nSites = 0;

    public PerSampleReadStateManager(LIBSDownsamplingInfo info) {
        Utils.nonNull(info);
        this.downsamplingTarget = info.isPerformDownsampling() ? info.getToCoverage() : -1;
        this.levelingDownsampler = info.isPerformDownsampling() ? new LevelingDownsampler(info.getToCoverage()) : null;
    }

    private List<LinkedList<AlignmentStateMachine>> groupByAlignmentStart() {
        LinkedList<LinkedList<AlignmentStateMachine>> grouped = new LinkedList<LinkedList<AlignmentStateMachine>>();
        AlignmentStateMachine last = null;
        for (AlignmentStateMachine stateMachine : this.readStatesByAlignmentStart) {
            if (last == null || stateMachine.getGenomeOffset() != last.getGenomeOffset()) {
                grouped.add(new LinkedList());
                last = stateMachine;
            }
            grouped.getLast().add(stateMachine);
        }
        return grouped;
    }

    private LinkedList<AlignmentStateMachine> flattenByAlignmentStart(List<LinkedList<AlignmentStateMachine>> grouped) {
        LinkedList<AlignmentStateMachine> flat = new LinkedList<AlignmentStateMachine>();
        for (List list : grouped) {
            flat.addAll(list);
        }
        return flat;
    }

    public int addStatesAtNextAlignmentStart(List<AlignmentStateMachine> states) {
        Utils.nonNull(states);
        if (states.isEmpty()) {
            return 0;
        }
        this.readStatesByAlignmentStart.addAll(states);
        int nStatesAdded = states.size();
        if (this.isDownsampling() && this.readStatesByAlignmentStart.size() > this.downsamplingTarget) {
            this.captureDownsamplingStats();
            this.levelingDownsampler.submit(this.groupByAlignmentStart());
            this.levelingDownsampler.signalEndOfInput();
            nStatesAdded -= this.levelingDownsampler.getNumberOfDiscardedItems();
            this.readStatesByAlignmentStart = this.flattenByAlignmentStart(this.levelingDownsampler.consumeFinalizedItems());
            this.levelingDownsampler.resetStats();
        }
        return nStatesAdded;
    }

    private boolean isDownsampling() {
        return this.levelingDownsampler != null;
    }

    public AlignmentStateMachine getFirst() {
        return this.isEmpty() ? null : this.readStatesByAlignmentStart.get(0);
    }

    private void captureDownsamplingStats() {
    }

    public boolean isEmpty() {
        return this.readStatesByAlignmentStart.isEmpty();
    }

    public int size() {
        return this.readStatesByAlignmentStart.size();
    }

    public int updateReadStates() {
        int nRemoved = 0;
        Iterator<AlignmentStateMachine> it = this.iterator();
        while (it.hasNext()) {
            AlignmentStateMachine state = it.next();
            CigarOperator op = state.stepForwardOnGenome();
            if (op != null) continue;
            it.remove();
            ++nRemoved;
        }
        return nRemoved;
    }

    @Override
    public Iterator<AlignmentStateMachine> iterator() {
        return this.readStatesByAlignmentStart.iterator();
    }
}

