/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.locusiterator;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.PeekableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.locusiterator.AlignmentStateMachine;
import org.broadinstitute.hellbender.utils.locusiterator.LIBSDownsamplingInfo;
import org.broadinstitute.hellbender.utils.locusiterator.PerSampleReadStateManager;
import org.broadinstitute.hellbender.utils.locusiterator.SamplePartitioner;
import org.broadinstitute.hellbender.utils.read.GATKRead;

final class ReadStateManager
implements Iterable<Map.Entry<String, PerSampleReadStateManager>> {
    private final List<String> samples;
    private final PeekableIterator<GATKRead> iterator;
    private final SamplePartitioner samplePartitioner;
    private final Map<String, PerSampleReadStateManager> readStatesBySample = new LinkedHashMap<String, PerSampleReadStateManager>();
    private List<GATKRead> submittedReads;
    private final boolean keepSubmittedReads;
    private int totalReadStates = 0;

    public ReadStateManager(Iterator<GATKRead> source, List<String> samples, LIBSDownsamplingInfo info, boolean keepSubmittedReads, SAMFileHeader header) {
        Utils.nonNull(source, "source");
        Utils.nonNull(samples, "samples");
        Utils.nonNull(info, "downsampling info");
        Utils.nonNull(header, "header");
        this.samples = samples;
        this.iterator = new PeekableIterator(source);
        this.keepSubmittedReads = keepSubmittedReads;
        this.submittedReads = new LinkedList<GATKRead>();
        for (String sample : samples) {
            this.readStatesBySample.put(sample, new PerSampleReadStateManager(info));
        }
        this.samplePartitioner = new SamplePartitioner(info, samples, header);
    }

    @Override
    public Iterator<Map.Entry<String, PerSampleReadStateManager>> iterator() {
        return this.readStatesBySample.entrySet().iterator();
    }

    public boolean isEmpty() {
        return this.totalReadStates == 0;
    }

    public int size() {
        return this.totalReadStates;
    }

    public int size(String sample) {
        Utils.nonNull(sample);
        return this.readStatesBySample.get(sample).size();
    }

    public AlignmentStateMachine getFirst() {
        for (PerSampleReadStateManager manager : this.readStatesBySample.values()) {
            if (manager.isEmpty()) continue;
            return manager.getFirst();
        }
        return null;
    }

    public boolean hasNext() {
        return this.totalReadStates > 0 || this.iterator.hasNext();
    }

    public void updateReadStates() {
        for (PerSampleReadStateManager perSampleReadStateManager : this.readStatesBySample.values()) {
            this.totalReadStates -= perSampleReadStateManager.updateReadStates();
        }
    }

    private boolean readStartsAtCurrentPosition(GATKRead read, String currentContig, int currentAlignmentStart) {
        return read.getStart() == currentAlignmentStart && read.getContig().equals(currentContig);
    }

    public void collectPendingReads() {
        int firstAlignmentStart;
        String firstContig;
        if (!this.iterator.hasNext()) {
            return;
        }
        if (this.isEmpty()) {
            firstContig = ((GATKRead)this.iterator.peek()).getContig();
            firstAlignmentStart = ((GATKRead)this.iterator.peek()).getStart();
        } else {
            AlignmentStateMachine firstState = this.getFirst();
            firstContig = firstState.getContig();
            firstAlignmentStart = firstState.getGenomePosition();
        }
        while (this.iterator.hasNext() && this.readStartsAtCurrentPosition((GATKRead)this.iterator.peek(), firstContig, firstAlignmentStart)) {
            this.submitRead((GATKRead)this.iterator.next());
        }
        this.samplePartitioner.doneSubmittingReads();
        for (String sample : this.samples) {
            Collection<GATKRead> newReads = this.samplePartitioner.getReadsForSample(sample);
            if (this.keepSubmittedReads) {
                this.submittedReads.addAll(newReads);
            }
            PerSampleReadStateManager statesBySample = this.readStatesBySample.get(sample);
            this.addReadsToSample(statesBySample, newReads);
        }
        this.samplePartitioner.reset();
    }

    void submitRead(GATKRead read) {
        this.samplePartitioner.submitRead(read);
    }

    public List<GATKRead> transferSubmittedReads() {
        Utils.validate(this.keepSubmittedReads, "cannot transferSubmittedReads if you aren't keeping them");
        List<GATKRead> prevSubmittedReads = this.submittedReads;
        this.submittedReads = new LinkedList<GATKRead>();
        return prevSubmittedReads;
    }

    public boolean isKeepingSubmittedReads() {
        return this.keepSubmittedReads;
    }

    @VisibleForTesting
    List<GATKRead> getSubmittedReads() {
        return this.submittedReads;
    }

    private void addReadsToSample(PerSampleReadStateManager readStates, Collection<GATKRead> reads) {
        if (reads.isEmpty()) {
            return;
        }
        LinkedList<AlignmentStateMachine> newReadStates = new LinkedList<AlignmentStateMachine>();
        for (GATKRead read : reads) {
            AlignmentStateMachine state = new AlignmentStateMachine(read);
            if (state.stepForwardOnGenome() == null) continue;
            newReadStates.add(state);
        }
        this.totalReadStates += readStates.addStatesAtNextAlignmentStart(newReadStates);
    }
}

