/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.locusiterator;

import htsjdk.samtools.SAMFileHeader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.downsampling.Downsampler;
import org.broadinstitute.hellbender.utils.downsampling.PassThroughDownsampler;
import org.broadinstitute.hellbender.utils.downsampling.ReservoirDownsampler;
import org.broadinstitute.hellbender.utils.locusiterator.LIBSDownsamplingInfo;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.read.ReadUtils;

final class SamplePartitioner {
    private final Map<String, Downsampler<GATKRead>> readsBySample;
    boolean doneSubmittingReads = false;
    private final SAMFileHeader header;

    public SamplePartitioner(LIBSDownsamplingInfo LIBSDownsamplingInfo2, List<String> samples, SAMFileHeader header) {
        Utils.nonNull(LIBSDownsamplingInfo2, "LIBSDownsamplingInfo cannot be null");
        Utils.nonNull(samples, "samples must be a non-null list");
        Utils.nonNull(header, "header must be not null");
        this.readsBySample = new LinkedHashMap<String, Downsampler<GATKRead>>(samples.size());
        for (String sample : samples) {
            this.readsBySample.put(sample, this.createDownsampler(LIBSDownsamplingInfo2));
        }
        this.header = header;
    }

    private Downsampler<GATKRead> createDownsampler(LIBSDownsamplingInfo LIBSDownsamplingInfo2) {
        return LIBSDownsamplingInfo2.isPerformDownsampling() ? new ReservoirDownsampler(LIBSDownsamplingInfo2.getToCoverage(), true) : new PassThroughDownsampler();
    }

    public void submitRead(GATKRead read) {
        Utils.nonNull(read);
        String sampleName = read.getReadGroup() != null ? ReadUtils.getSampleName(read, this.header) : null;
        Downsampler<GATKRead> downsampler = this.readsBySample.get(sampleName);
        Utils.validate(downsampler != null, () -> "Offered read with sample name " + sampleName + " to SamplePartitioner but this sample wasn't provided as one of possible samples at construction");
        downsampler.submit(read);
        this.doneSubmittingReads = false;
    }

    public void doneSubmittingReads() {
        for (Downsampler<GATKRead> downsampler : this.readsBySample.values()) {
            downsampler.signalEndOfInput();
        }
        this.doneSubmittingReads = true;
    }

    public Collection<GATKRead> getReadsForSample(String sampleName) {
        Utils.validate(this.doneSubmittingReads, "getReadsForSample called before doneSubmittingReads was called");
        Downsampler<GATKRead> downsampler = this.readsBySample.get(sampleName);
        if (downsampler == null) {
            throw new NoSuchElementException("Sample name not found");
        }
        return downsampler.consumeFinalizedItems();
    }

    public void reset() {
        for (Downsampler<GATKRead> downsampler : this.readsBySample.values()) {
            downsampler.clearItems();
            downsampler.resetStats();
        }
        this.doneSubmittingReads = false;
    }
}

