/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.mcmc;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

abstract class AbstractSliceSampler {
    private static final int MAXIMUM_NUMBER_OF_DOUBLINGS = 16;
    private static final int MAXIMUM_NUMBER_OF_SLICE_SAMPLINGS = 100;
    private static final double EPSILON = 1.0E-10;
    final RandomGenerator rng;
    final double xMin;
    final double xMax;
    private final double width;
    private final ExponentialDistribution exponentialDistribution;

    AbstractSliceSampler(RandomGenerator rng, double xMin, double xMax, double width) {
        Utils.nonNull(rng);
        Utils.validateArg(xMin < xMax, "Maximum bound must be greater than minimum bound.");
        ParamUtils.isPositive(width, "Slice-sampling width must be positive.");
        this.rng = rng;
        this.xMin = xMin;
        this.xMax = xMax;
        this.width = width;
        this.exponentialDistribution = new ExponentialDistribution(rng, 1.0);
    }

    public double sample(double xInitial) {
        Utils.validateArg(this.xMin <= xInitial && xInitial <= this.xMax, "Initial point in slice sampler is not within specified range.");
        double xSample = Math.min(Math.max(xInitial, this.xMin + 1.0E-10), this.xMax - 1.0E-10);
        double z = this.exponentialDistribution.sample();
        double xLeft = xSample - this.width * this.rng.nextDouble();
        double xRight = xLeft + this.width;
        Function<Double, Boolean> isGreaterThanSliceHeight = xProposed -> this.isGreaterThanSliceHeight((double)xProposed, xSample, z);
        for (int k = 16; k > 0 && (isGreaterThanSliceHeight.apply(xLeft).booleanValue() || isGreaterThanSliceHeight.apply(xRight).booleanValue()); --k) {
            if (this.rng.nextBoolean()) {
                xLeft -= xRight - xLeft;
                continue;
            }
            xRight += xRight - xLeft;
        }
        double xProposed2 = this.rng.nextDouble() * (xRight - xLeft) + xLeft;
        for (int numIterations = 1; numIterations <= 100 && !isGreaterThanSliceHeight.apply(xProposed2).booleanValue(); ++numIterations) {
            if (xProposed2 < xSample) {
                xLeft = xProposed2;
            } else {
                xRight = xProposed2;
            }
            xProposed2 = this.rng.nextDouble() * (xRight - xLeft) + xLeft;
        }
        return Math.min(Math.max(xProposed2, this.xMin + 1.0E-10), this.xMax - 1.0E-10);
    }

    public List<Double> sample(double xInitial, int numSamples) {
        ParamUtils.isPositive(numSamples, "Number of samples must be positive.");
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        double xSample = xInitial;
        for (int i = 0; i < numSamples; ++i) {
            xSample = this.sample(xSample);
            samples.add(xSample);
        }
        return samples;
    }

    abstract boolean isGreaterThanSliceHeight(double var1, double var3, double var5);
}

