/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.mcmc;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public final class AdaptiveMetropolisSampler {
    private static final double DEFAULT_OPTIMAL_ACCEPTANCE_RATE = 0.4;
    private static final double DEFAULT_TIME_SCALE = 20.0;
    private static final double DEFAULT_ADJUSTMENT_RATE = 1.0;
    private int iteration = 1;
    private final double lowerBound;
    private final double upperBound;
    private double optimalAcceptanceRate = 0.4;
    private final double adjustmentRate;
    private final double timeScale;
    private double stepSize;
    private double xCurrent;

    public AdaptiveMetropolisSampler(double xInitial, double initialStepSize, double lowerBound, double upperBound, double adjustmentRate, double timeScale) {
        Utils.validateArg(lowerBound <= upperBound, "Maximum bound must be greater than or equal to minimum bound.");
        ParamUtils.isPositive(initialStepSize, "Step size must be positive.");
        ParamUtils.isPositive(timeScale, "Time scale must be positive.");
        this.xCurrent = xInitial;
        this.stepSize = initialStepSize;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.adjustmentRate = adjustmentRate;
        this.timeScale = timeScale;
    }

    public AdaptiveMetropolisSampler(double xInitial, double initialStepSize, double lowerBound, double upperBound) {
        this(xInitial, initialStepSize, lowerBound, upperBound, 1.0, 20.0);
    }

    public double sample(RandomGenerator rng, Function<Double, Double> logPDF) {
        Utils.nonNull(rng);
        Utils.nonNull(logPDF);
        NormalDistribution normal = new NormalDistribution(rng, 0.0, 1.0);
        double proposal = this.xCurrent + this.stepSize * normal.sample();
        double acceptanceProbability = proposal < this.lowerBound || this.upperBound < proposal ? 0.0 : Math.min(1.0, Math.exp(logPDF.apply(proposal) - logPDF.apply(this.xCurrent)));
        double correctionFactor = (acceptanceProbability - this.optimalAcceptanceRate) * this.adjustmentRate * (this.timeScale / (this.timeScale + (double)this.iteration));
        this.stepSize *= Math.exp(correctionFactor);
        ++this.iteration;
        return rng.nextDouble() < acceptanceProbability ? proposal : this.xCurrent;
    }

    public List<Double> sample(RandomGenerator rng, Function<Double, Double> logPDF, int numSamples, int numBurnIn) {
        Utils.nonNull(rng);
        Utils.nonNull(logPDF);
        ParamUtils.isPositive(numSamples, "Number of samples must be positive.");
        ParamUtils.isPositiveOrZero(numBurnIn, "Number of burn-in samples must be non-negative.");
        Utils.validateArg(numBurnIn < numSamples, "Number of samples must be greater than number of burn-in samples.");
        ArrayList<Double> samples = new ArrayList<Double>(numSamples);
        for (int i = 0; i < numSamples; ++i) {
            this.xCurrent = this.sample(rng, logPDF);
            if (i <= numBurnIn) continue;
            samples.add(this.xCurrent);
        }
        return samples;
    }
}

