/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.mcmc;

import com.google.common.primitives.Doubles;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.mcmc.Decile;

public final class DecileCollection
implements Serializable {
    static final long serialVersionUID = 145L;
    private final Map<Decile, Double> deciles = new HashMap<Decile, Double>();

    public DecileCollection(List<Double> samples) {
        Utils.nonNull(samples);
        Utils.validateArg(!samples.isEmpty(), "Cannot construct deciles for empty list of samples.");
        Percentile percentile = new Percentile();
        percentile.setData(Doubles.toArray(samples));
        Decile[] decileKeys = Decile.values();
        for (int i = 1; i < 10; ++i) {
            double decile = percentile.evaluate((double)(10 * i));
            this.deciles.put(decileKeys[i - 1], decile);
        }
    }

    public double get(Decile decile) {
        return this.deciles.get((Object)decile);
    }

    public List<Double> getAll() {
        return Collections.unmodifiableList(Stream.of(Decile.values()).map(this.deciles::get).collect(Collectors.toList()));
    }
}

