/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.mcmc;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.RandomGeneratorFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.mcmc.DataCollection;
import org.broadinstitute.hellbender.utils.mcmc.ParameterizedModel;
import org.broadinstitute.hellbender.utils.mcmc.ParameterizedState;
import org.broadinstitute.hellbender.utils.param.ParamUtils;

public final class GibbsSampler<V extends Enum<V>, S extends ParameterizedState<V>, T extends DataCollection> {
    private static final int RANDOM_SEED = 42;
    private static final RandomGenerator rng = RandomGeneratorFactory.createRandomGenerator((Random)new Random(42L));
    private static final Logger logger = LogManager.getLogger(GibbsSampler.class);
    private static final int NUMBER_OF_SAMPLES_PER_LOG_ENTRY = 25;
    private final int numSamples;
    private int numSamplesPerLogEntry;
    private final ParameterizedModel<V, S, T> model;
    private final List<S> samples;
    private boolean isMCMCRunComplete = false;

    public GibbsSampler(int numSamples, ParameterizedModel<V, S, T> model) {
        ParamUtils.isPositive(numSamples, "Number of samples must be positive.");
        Utils.validateArg(model.getUpdateMethod() == ParameterizedModel.UpdateMethod.GIBBS, "ParameterizedModel must be constructed to update using Gibbs sampling.");
        this.numSamples = numSamples;
        this.model = model;
        this.numSamplesPerLogEntry = 25;
        this.samples = new ArrayList<S>(numSamples);
        this.samples.add(model.state());
    }

    public void setNumSamplesPerLogEntry(int numSamplesPerLogEntry) {
        ParamUtils.isPositive(numSamplesPerLogEntry, "Number of samples per log entry must be positive.");
        this.numSamplesPerLogEntry = numSamplesPerLogEntry;
    }

    public void runMCMC() {
        rng.setSeed(42);
        logger.info("Starting MCMC sampling.");
        for (int sample = 1; sample < this.numSamples; ++sample) {
            if (sample % this.numSamplesPerLogEntry == 0) {
                logger.info(sample + " of " + this.numSamples + " samples generated.");
            }
            this.model.update(rng);
            this.samples.add(this.model.state());
        }
        logger.info(this.numSamples + " of " + this.numSamples + " samples generated.");
        logger.info("MCMC sampling complete.");
        this.isMCMCRunComplete = true;
    }

    public <U> List<U> getSamples(V parameterName, Class<U> parameterValueClass, int numBurnIn) {
        ParamUtils.isPositiveOrZero(numBurnIn, "Number of burn-in samples must be non-negative.");
        Utils.validateArg(numBurnIn < this.numSamples, "Number of samples must be greater than number of burn-in samples.");
        if (!this.isMCMCRunComplete) {
            this.runMCMC();
        }
        return this.samples.stream().map(s -> s.get(parameterName, parameterValueClass)).collect(Collectors.toList()).subList(numBurnIn, this.numSamples);
    }
}

